/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.io.PrintStream;
import org.itsallcode.openfasttrace.api.core.Trace;
import org.itsallcode.openfasttrace.report.html.view.IndentationHelper;
import org.itsallcode.openfasttrace.report.html.view.Viewable;

class HtmlTraceSummary
implements Viewable {
    private final PrintStream stream;
    private final Trace trace;

    HtmlTraceSummary(PrintStream stream, Trace trace) {
        this.stream = stream;
        this.trace = trace;
    }

    @Override
    public void render(int level) {
        String indentation = IndentationHelper.createIndentationPrefix(level);
        this.renderStart(indentation);
        this.renderStatusIndicator();
        this.renderTotalCount();
        this.renderCompletionIndicator();
        this.renderDefectCount();
        this.renderEnd();
    }

    protected void renderStart(String indentation) {
        this.stream.print(indentation);
    }

    protected void renderStatusIndicator() {
        this.stream.print(this.trace.hasNoDefects() ? "<span class=\"green\">&check;</span>" : "<span class=\"red\">&cross;</span>");
        this.stream.print(" ");
    }

    protected void renderTotalCount() {
        this.stream.print(this.trace.count());
        this.stream.print(" total ");
    }

    protected void renderCompletionIndicator() {
        int count = this.trace.count();
        if (count == 0) {
            this.stream.print("<meter>100%</meter>");
        } else {
            int value = count - this.trace.countDefects();
            int percent = 100 * value / count;
            this.stream.print("<meter value=\"");
            this.stream.print(value);
            if (value < count) {
                this.stream.print("\" low=\"");
                this.stream.print(count - 1);
            }
            this.stream.print("\" max=\"");
            this.stream.print(count);
            this.stream.print("\">");
            this.stream.print(percent);
            this.stream.print("%</meter>");
        }
    }

    private void renderDefectCount() {
        if (!this.trace.hasNoDefects()) {
            this.stream.print(" <span class=\".red\">");
            this.stream.print(this.trace.countDefects());
            this.stream.print(" defects</span>");
        }
    }

    protected void renderEnd() {
    }
}

