/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import org.itsallcode.openfasttrace.api.report.ReportException;
import org.itsallcode.openfasttrace.report.html.view.AbstractStreamableViewContainer;

class HtmlView
extends AbstractStreamableViewContainer {
    private final URL cssURL;

    HtmlView(PrintStream stream, String id, String title, URL cssURL) {
        super(stream, id, title);
        this.cssURL = cssURL;
    }

    @Override
    public void renderBeforeChildren(int level) {
        this.stream.println("<!DOCTYPE html>");
        this.stream.println("<html>");
        this.stream.println("  <head>");
        this.stream.println("    <meta charset=\"UTF-8\">");
        this.stream.println("    <style>");
        this.inlineCSS();
        this.stream.println("    </style>");
        this.stream.print("    <title>");
        this.stream.print(this.getTitle());
        this.stream.println("</title>");
        this.stream.println("  </head>");
        this.stream.println("  <body>");
    }

    private void inlineCSS() {
        try (InputStream css = this.cssURL.openStream();){
            int n;
            byte[] buffer = new byte[4096];
            while ((n = css.read(buffer)) > 0) {
                this.stream.write(buffer, 0, n);
            }
        }
        catch (IOException exception) {
            throw new ReportException("Unable to copy CSS content \"" + this.cssURL.toString() + "\" trying to generate HTML view.", (Throwable)exception);
        }
    }

    @Override
    public void renderAfterChildren(int level) {
        this.stream.println("  </body>");
        this.stream.print("</html>");
    }
}

