/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.itsallcode.openfasttrace.api.DetailsSectionDisplay;
import org.itsallcode.openfasttrace.api.core.LinkedSpecificationItem;
import org.itsallcode.openfasttrace.api.core.Trace;
import org.itsallcode.openfasttrace.api.exporter.ExporterException;
import org.itsallcode.openfasttrace.report.html.view.AbstractViewFactory;
import org.itsallcode.openfasttrace.report.html.view.Viewable;
import org.itsallcode.openfasttrace.report.html.view.ViewableContainer;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlReportDetails;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlReportSummary;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlSection;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlSpecificationItem;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlTableOfContents;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlTraceSummary;
import org.itsallcode.openfasttrace.report.html.view.html.HtmlView;

public class HtmlViewFactory
extends AbstractViewFactory {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final URL cssUrl;
    private final DetailsSectionDisplay sectionDisplay;

    private HtmlViewFactory(PrintStream stream, URL cssUrl, DetailsSectionDisplay sectionDisplay) {
        super(stream);
        this.cssUrl = cssUrl;
        this.sectionDisplay = sectionDisplay;
    }

    public static HtmlViewFactory create(OutputStream stream, URL cssURL, DetailsSectionDisplay displayStatus) {
        return new HtmlViewFactory(HtmlViewFactory.createPrintStream(stream), cssURL, displayStatus);
    }

    private static PrintStream createPrintStream(OutputStream stream) {
        if (stream instanceof PrintStream) {
            return (PrintStream)stream;
        }
        return HtmlViewFactory.createPrintStream(stream, DEFAULT_CHARSET);
    }

    private static PrintStream createPrintStream(OutputStream stream, Charset charset) {
        try {
            return new PrintStream(stream, false, charset.name());
        }
        catch (UnsupportedEncodingException exception) {
            throw new ExporterException("Error creating print stream for charset " + charset, (Throwable)exception);
        }
    }

    @Override
    public ViewableContainer createView(String id, String title) {
        return new HtmlView(this.outputStream, id, title, this.cssUrl);
    }

    @Override
    public ViewableContainer createReportDetails() {
        return new HtmlReportDetails(this.outputStream);
    }

    @Override
    public ViewableContainer createSection(String id, String title) {
        return new HtmlSection(this.outputStream, id, title);
    }

    @Override
    public Viewable createSpecificationItem(LinkedSpecificationItem item) {
        return new HtmlSpecificationItem(this.outputStream, item, this.sectionDisplay);
    }

    @Override
    public Viewable createTraceSummary(Trace trace) {
        return new HtmlTraceSummary(this.outputStream, trace);
    }

    @Override
    public ViewableContainer createReportSummary() {
        return new HtmlReportSummary(this.outputStream);
    }

    @Override
    public Viewable createTableOfContents(ViewableContainer from) {
        return new HtmlTableOfContents(this.outputStream, from);
    }
}

