/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.itsallcode.openfasttrace.report.html.view.html.MarkdownLineState;
import org.itsallcode.openfasttrace.report.html.view.html.MarkdownLineTransition;
import org.itsallcode.openfasttrace.report.html.view.html.MarkdownSpanConverter;

public final class MarkdownLineStateMachine {
    private static final int INCLUDE_EMPTY_STRINGS = -1;
    private static final String P_ANY = ".*";
    private static final String P_OL_LI = "^ {0,3}[0-9]+\\..*";
    private static final String P_UL_LI = "^ {0,3}[-+*].*";
    private static final String P_PRE = "^    .*";
    private static final String P_LIST_CONT = ".+";
    private static final String P_TERM = "^$";
    private final List<MarkdownLineTransition> transitions = new ArrayList<MarkdownLineTransition>();

    MarkdownLineStateMachine() {
        this.initializeTransitions();
    }

    private void initializeTransitions() {
        this.t(MarkdownLineState.START, MarkdownLineState.PREFORMATTED, P_PRE, "", "<pre>", this.trimPre());
        this.t(MarkdownLineState.START, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "", "<ul><li>", this.trimBullet());
        this.t(MarkdownLineState.START, MarkdownLineState.ORDERED_LIST, P_OL_LI, "", "<ol><li>", this.trimEnum());
        this.t(MarkdownLineState.START, MarkdownLineState.PARAGRAPH, P_ANY, "", "<p>", String::trim);
        this.t(MarkdownLineState.START, MarkdownLineState.TERMINATOR, P_TERM, "", "", this.empty());
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "</li>", "<li>", this.trimBullet());
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.ORDERED_LIST, P_UL_LI, "</li></ul>", "<ol><li>", this.trimEnum());
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.UNORDERED_LIST, P_LIST_CONT, "", " ", String::trim);
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.PREFORMATTED, P_PRE, "</li></ul>", "<pre>", this.trimPre());
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.TERMINATOR, P_TERM, "</li></ul>", "", this.empty());
        this.t(MarkdownLineState.UNORDERED_LIST, MarkdownLineState.PARAGRAPH, P_ANY, "</li></ul>", "<p>", String::trim);
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "</li></ol>", "<ul><li>", this.trimBullet());
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.ORDERED_LIST, P_OL_LI, "</li>", "<li>", this.trimEnum());
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.UNORDERED_LIST, P_LIST_CONT, "", " ", String::trim);
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.PREFORMATTED, P_PRE, "</li></ol>", "<pre>", this.trimPre());
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.TERMINATOR, P_TERM, "</li></ol>", "", this.empty());
        this.t(MarkdownLineState.ORDERED_LIST, MarkdownLineState.PARAGRAPH, P_ANY, "</li></ol>", "<p>", String::trim);
        this.t(MarkdownLineState.PREFORMATTED, MarkdownLineState.PREFORMATTED, P_PRE, "", "\n", this.trimPre());
        this.t(MarkdownLineState.PREFORMATTED, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "</pre>", "<ul><li>", this.trimBullet());
        this.t(MarkdownLineState.PREFORMATTED, MarkdownLineState.ORDERED_LIST, P_OL_LI, "</pre>", "<ol><li>", this.trimEnum());
        this.t(MarkdownLineState.PREFORMATTED, MarkdownLineState.TERMINATOR, P_TERM, "</pre>", "", this.empty());
        this.t(MarkdownLineState.PREFORMATTED, MarkdownLineState.PARAGRAPH, P_ANY, "</pre>", "<p>", String::trim);
        this.t(MarkdownLineState.TERMINATOR, MarkdownLineState.TERMINATOR, P_TERM, "", "", this.empty());
        this.t(MarkdownLineState.TERMINATOR, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "", "<ul><li>", this.trimBullet());
        this.t(MarkdownLineState.TERMINATOR, MarkdownLineState.ORDERED_LIST, P_OL_LI, "", "<ol><li>", this.trimEnum());
        this.t(MarkdownLineState.TERMINATOR, MarkdownLineState.PREFORMATTED, P_PRE, "", "<pre>", this.trimPre());
        this.t(MarkdownLineState.TERMINATOR, MarkdownLineState.PARAGRAPH, P_ANY, "", "<p>", String::trim);
        this.t(MarkdownLineState.PARAGRAPH, MarkdownLineState.UNORDERED_LIST, P_UL_LI, "</p>", "<ul><li>", this.trimBullet());
        this.t(MarkdownLineState.PARAGRAPH, MarkdownLineState.ORDERED_LIST, P_OL_LI, "</p>", "<ol><li>", this.trimEnum());
        this.t(MarkdownLineState.PARAGRAPH, MarkdownLineState.PREFORMATTED, P_PRE, "</p>", "<pre>", String::trim);
        this.t(MarkdownLineState.PARAGRAPH, MarkdownLineState.TERMINATOR, P_TERM, "</p>", "", this.empty());
        this.t(MarkdownLineState.PARAGRAPH, MarkdownLineState.PARAGRAPH, P_ANY, "", " ", String::trim);
    }

    private void t(MarkdownLineState from, MarkdownLineState to, String pattern, String postfix, String prefix, UnaryOperator<String> conversion) {
        this.transitions.add(new MarkdownLineTransition(from, to, pattern, prefix, postfix, conversion));
    }

    String run(String input) {
        StringBuilder builder = new StringBuilder();
        MarkdownLineState state = MarkdownLineState.START;
        block0: for (String line : input.split("(?:\n\r?|\r)", -1)) {
            for (MarkdownLineTransition transition : this.transitions) {
                if (transition.getFrom() != state || !transition.getPattern().matcher(line).matches()) continue;
                builder.append(transition.getPostfix());
                builder.append(transition.getPrefix());
                builder.append(MarkdownSpanConverter.convertLineContent(transition.getConversion().apply(line)));
                state = transition.getTo();
                continue block0;
            }
        }
        this.closeLastLineState(builder, state);
        return builder.toString();
    }

    private void closeLastLineState(StringBuilder builder, MarkdownLineState state) {
        switch (state) {
            case PREFORMATTED: {
                builder.append("</pre>");
                break;
            }
            case UNORDERED_LIST: {
                builder.append("</li></ul>");
                break;
            }
            case ORDERED_LIST: {
                builder.append("</li></ol>");
                break;
            }
            case PARAGRAPH: {
                builder.append("</p>");
                break;
            }
            case TERMINATOR: {
                break;
            }
            default: {
                throw new IllegalStateException("MarkdownLineStateMachine terminates with unknown end state");
            }
        }
    }

    private UnaryOperator<String> empty() {
        return s -> "";
    }

    private UnaryOperator<String> trimEnum() {
        return s -> s.substring(s.indexOf(46) + 1).trim();
    }

    private UnaryOperator<String> trimPre() {
        return s -> s.substring(4);
    }

    private UnaryOperator<String> trimBullet() {
        return s -> s.replaceFirst("^ {0,3}[-+*]", "").trim();
    }
}

