/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.html.view.html;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.itsallcode.openfasttrace.api.core.Location;

final class OriginLinkFormatter {
    private static final Pattern PROTOCOL_PREFIX_PATTERN = Pattern.compile("^(?:file://|ftp://|mailto:|https?://).*");

    private OriginLinkFormatter() {
    }

    static String formatAsSpan(Location location) {
        return OriginLinkFormatter.format(location, true);
    }

    static String formatAsBlock(Location location) {
        return OriginLinkFormatter.format(location, false);
    }

    private static String format(Location location, boolean asSpan) {
        if (location != null && !location.getPath().isEmpty()) {
            return OriginLinkFormatter.formatNonEmptyLocation(location, asSpan);
        }
        return "";
    }

    private static String formatNonEmptyLocation(Location location, boolean asSpan) {
        String path = location.getPath();
        URI uri = OriginLinkFormatter.checkPathHasProtocol(path) ? OriginLinkFormatter.convertPathWithProtocolToUri(path) : OriginLinkFormatter.convertPathWithoutProtocolToUri(path);
        StringBuilder builder = new StringBuilder();
        builder.append(asSpan ? "<span" : "<p");
        builder.append(" class=\"origin\">");
        if (uri != null) {
            builder.append("<a href=\"");
            builder.append(uri);
            builder.append("\">");
            builder.append(path);
            builder.append("</a>");
        } else {
            builder.append(path);
        }
        builder.append(":");
        int line = location.getLine();
        builder.append(line);
        builder.append(asSpan ? "</span>" : "</p>");
        return builder.toString();
    }

    private static boolean checkPathHasProtocol(String path) {
        return PROTOCOL_PREFIX_PATTERN.matcher(path).matches();
    }

    private static URI convertPathWithProtocolToUri(String path) {
        try {
            return URI.create(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static URI convertPathWithoutProtocolToUri(String path) {
        Path realPath = Paths.get(OriginLinkFormatter.unWindowsify(path), new String[0]);
        if (realPath.isAbsolute()) {
            return realPath.toUri();
        }
        return null;
    }

    private static String unWindowsify(String path) {
        return path.replace("\\\\", "/");
    }
}

