/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.plaintext;

enum AnsiSequence {
    RESET(0),
    BOLD(1),
    ITALIC(3),
    UNDERLINE(4),
    INVERSE(7),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    MAGENTA(35),
    CYAN(36),
    WHITE(37),
    BRIGHT_RED(91);

    public static final String PREFIX = "\u001b[";
    public static final String SUFFIX = "m";
    private final int id;

    private AnsiSequence(int id) {
        this.id = id;
    }

    public String toString() {
        return PREFIX + this.id + SUFFIX;
    }

    public int getId() {
        return this.id;
    }

    public static String combine(AnsiSequence ... ids) {
        StringBuilder builder = new StringBuilder(PREFIX);
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                builder.append(";");
            }
            builder.append(ids[i].id);
        }
        builder.append(SUFFIX);
        return builder.toString();
    }
}

