/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.report.plaintext;

import org.itsallcode.openfasttrace.api.ColorScheme;
import org.itsallcode.openfasttrace.report.plaintext.ConsoleColorFormatter;
import org.itsallcode.openfasttrace.report.plaintext.MonochromeTextFormatter;
import org.itsallcode.openfasttrace.report.plaintext.NullTextFormatter;
import org.itsallcode.openfasttrace.report.plaintext.TextFormatter;

final class TextFormatterFactory {
    private TextFormatterFactory() {
    }

    public static TextFormatter createFormatter(ColorScheme colorScheme) {
        if (colorScheme == null) {
            return new NullTextFormatter();
        }
        switch (colorScheme) {
            case BLACK_AND_WHITE: {
                return new NullTextFormatter();
            }
            case MONOCHROME: {
                return new MonochromeTextFormatter();
            }
            case COLOR: {
                return new ConsoleColorFormatter();
            }
        }
        throw new IllegalArgumentException("Unable to create text formatter for unknown color scheme '" + colorScheme + "'.");
    }
}

