package org.iworkz.genesis.vertx.maven;

import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicInteger;

import io.vertx.core.json.JsonObject;

public class MavenServiceOptions {

    private final AtomicInteger usages = new AtomicInteger();

    private final byte[] checksum;
    private final String mainVerticleName;
    private final URLClassLoader urlClassLoader;
    private final JsonObject deploymentOptions;

    public MavenServiceOptions(byte[] checksum, String mainVerticleName, URLClassLoader urlClassLoader) {
        this(checksum, mainVerticleName, urlClassLoader, null);
    }

    public MavenServiceOptions(byte[] checksum, String mainVerticleName, URLClassLoader urlClassLoader,
                          JsonObject deploymentOptions) {
        this.checksum = checksum;
        this.mainVerticleName = mainVerticleName;
        this.urlClassLoader = urlClassLoader;
        this.deploymentOptions = deploymentOptions;
    }

    public byte[] getChecksum() {
        return checksum;
    }

    public String getMainVerticleName() {
        return mainVerticleName;
    }

    public URLClassLoader getUrlClassLoader() {
        return urlClassLoader;
    }

    public int incrementUsage() {
        return usages.incrementAndGet();
    }

    public int decrementAndGetUsage() {
        return usages.decrementAndGet();

    }

    public JsonObject getDeploymentOptions() {
        return deploymentOptions;
    }
}
