/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.BundleCreator;
import org.jacoco.maven.FileFilter;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportMojo
extends AbstractMavenReport {
    protected String outputEncoding;
    protected String sourceEncoding;
    protected List<String> includes;
    protected List<String> excludes;
    protected boolean skip;
    protected MavenProject project;
    protected Renderer siteRenderer;
    protected SessionInfoStore sessionInfoStore;
    protected ExecutionDataStore executionDataStore;

    public abstract String getOutputName();

    public abstract String getName(Locale var1);

    public String getDescription(Locale locale) {
        return this.getName(locale) + " Coverage Report.";
    }

    public boolean isExternalReport() {
        return true;
    }

    protected abstract String getOutputDirectory();

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected List<String> getIncludes() {
        return this.includes;
    }

    protected List<String> getExcludes() {
        return this.excludes;
    }

    public abstract void setReportOutputDirectory(File var1);

    public boolean canGenerateReport() {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping JaCoCo for project with packaging type 'pom'");
            return false;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution");
            return false;
        }
        if (!this.getDataFile().exists()) {
            this.getLog().info((CharSequence)"Skipping JaCoCo execution due to missing execution data file");
            return false;
        }
        return true;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            return;
        }
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation.", (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.loadExecutionData();
        try {
            IReportVisitor visitor = this.createVisitor(locale);
            visitor.visitInfo(this.sessionInfoStore.getInfos(), this.executionDataStore.getContents());
            this.createReport((IReportGroupVisitor)visitor);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MavenReportException("Error while creating report: " + e.getMessage(), (Exception)e);
        }
    }

    protected void loadExecutionData() throws MavenReportException {
        ExecFileLoader loader = new ExecFileLoader();
        try {
            loader.load(this.getDataFile());
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to read execution data file " + this.getDataFile() + ": " + e.getMessage(), (Exception)e);
        }
        this.sessionInfoStore = loader.getSessionInfoStore();
        this.executionDataStore = loader.getExecutionDataStore();
    }

    protected void createReport(IReportGroupVisitor visitor) throws IOException {
        FileFilter fileFilter = new FileFilter(this.getIncludes(), this.getExcludes());
        BundleCreator creator = new BundleCreator(this.getProject(), fileFilter);
        IBundleCoverage bundle = creator.createBundle(this.executionDataStore);
        SourceFileCollection locator = new SourceFileCollection(this.getCompileSourceRoots(), this.sourceEncoding);
        this.checkForMissingDebugInformation((ICoverageNode)bundle);
        visitor.visitBundle(bundle, (ISourceFileLocator)locator);
    }

    protected void checkForMissingDebugInformation(ICoverageNode node) {
        if (node.getClassCounter().getTotalCount() > 0 && node.getLineCounter().getTotalCount() == 0) {
            this.getLog().warn((CharSequence)"To enable source code annotation class files have to be compiled with debug information.");
        }
    }

    protected IReportVisitor createVisitor(Locale locale) throws IOException {
        ArrayList<IReportVisitor> visitors = new ArrayList<IReportVisitor>();
        this.getOutputDirectoryFile().mkdirs();
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(xmlFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.getOutputDirectoryFile(), "jacoco.xml"))));
        CSVFormatter csvFormatter = new CSVFormatter();
        csvFormatter.setOutputEncoding(this.outputEncoding);
        visitors.add(csvFormatter.createVisitor((OutputStream)new FileOutputStream(new File(this.getOutputDirectoryFile(), "jacoco.csv"))));
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(this.outputEncoding);
        htmlFormatter.setLocale(locale);
        visitors.add(htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.getOutputDirectoryFile())));
        return new MultiReportVisitor(visitors);
    }

    protected File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.getProject().getBasedir(), path);
        }
        return file;
    }

    protected List<File> getCompileSourceRoots() {
        ArrayList<File> result = new ArrayList<File>();
        for (Object path : this.getProject().getCompileSourceRoots()) {
            result.add(this.resolvePath((String)path));
        }
        return result;
    }

    protected abstract File getDataFile();

    protected abstract File getOutputDirectoryFile();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceFileCollection
    implements ISourceFileLocator {
        private final List<File> sourceRoots;
        private final String encoding;

        public SourceFileCollection(List<File> sourceRoots, String encoding) {
            this.sourceRoots = sourceRoots;
            this.encoding = encoding;
        }

        public Reader getSourceFile(String packageName, String fileName) throws IOException {
            String r = packageName.length() > 0 ? packageName + '/' + fileName : fileName;
            for (File sourceRoot : this.sourceRoots) {
                File file = new File(sourceRoot, r);
                if (!file.exists() || !file.isFile()) continue;
                return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            }
            return null;
        }

        public int getTabWidth() {
            return 4;
        }
    }
}

