/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.maven.AbstractJacocoMojo;

public class MergeMojo
extends AbstractJacocoMojo {
    private static final String MSG_SKIPPING = "Skipping JaCoCo merge execution due to missing execution data files";
    private File destFile;
    private ArrayList<FileSet> fileSets;

    protected void executeMojo() throws MojoExecutionException, MojoFailureException {
        if (!this.canMergeReports()) {
            return;
        }
        this.executeMerge();
    }

    private boolean canMergeReports() {
        if (this.fileSets == null || this.fileSets.isEmpty()) {
            this.getLog().info((CharSequence)MSG_SKIPPING);
            return false;
        }
        return true;
    }

    private void executeMerge() throws MojoExecutionException {
        ExecFileLoader loader = new ExecFileLoader();
        this.load(loader);
        this.save(loader);
    }

    private void load(ExecFileLoader loader) throws MojoExecutionException {
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        for (FileSet fileSet : this.fileSets) {
            for (String includedFilename : fileSetManager.getIncludedFiles(fileSet)) {
                File inputFile = new File(fileSet.getDirectory(), includedFilename);
                if (inputFile.isDirectory()) continue;
                try {
                    this.getLog().info((CharSequence)("Loading execution data file " + inputFile.getAbsolutePath()));
                    loader.load(inputFile);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to read " + inputFile.getAbsolutePath(), (Exception)e);
                }
            }
        }
    }

    private void save(ExecFileLoader loader) throws MojoExecutionException {
        if (loader.getExecutionDataStore().getContents().isEmpty()) {
            this.getLog().info((CharSequence)MSG_SKIPPING);
            return;
        }
        this.getLog().info((CharSequence)("Writing merged execution data to " + this.destFile.getAbsolutePath()));
        try {
            loader.save(this.destFile, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write merged file " + this.destFile.getAbsolutePath(), (Exception)e);
        }
    }
}

