package org.jacoco.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jacoco-maven-plugin.<br/> Call <pre>  mvn jacoco:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri May 09 13:59:31 CEST 2014
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.8)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.jacoco:jacoco-maven-plugin:0.7.1.201405082137", 0 );
        append( sb, "", 0 );

        append( sb, "JaCoCo :: Maven Plugin", 0 );
        append( sb, "The JaCoCo Maven Plugin provides the JaCoCo runtime agent to your tests and allows basic report creation.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 10 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "jacoco:check", 0 );
            append( sb, "Checks that the code coverage metrics are being met.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataFile (Default: ${project.build.directory}/jacoco.exec)", 2 );
                append( sb, "File with execution data.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "haltOnFailure (Default: true)", 2 );
                append( sb, "Halt the build if any of the checks fail.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jacoco.haltOnFailure}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "rules", 2 );
                append( sb, "Check configuration used to specify rules on element types (BUNDLE, PACKAGE, CLASS, SOURCEFILE or METHOD) with a list of limits. Each limit applies to a certain counter (INSTRUCTION, LINE, BRANCH, COMPLEXITY, METHOD, CLASS) and defines a minimum or maximum for the corresponding value (TOTALCOUNT, COVEREDCOUNT, MISSEDCOUNT, COVEREDRATIO, MISSEDRATIO). If a limit refers to a ratio the range is from 0.0 to 1.0 where the number of decimal places will also determine the precision in error messages. Note that you must use implementation hints for rule and limit when using Maven 2, with Maven 3 you do not need to specify the attributes.\n\nThis example requires an overall instruction coverage of 80% and no class must be missed:\n\n<rules>\n\u00a0\u00a0<rule\u00a0implementation=\'org.jacoco.maven.RuleConfiguration\'>\n\u00a0\u00a0\u00a0\u00a0<element>BUNDLE</element>\n\u00a0\u00a0\u00a0\u00a0<limits>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<limit\u00a0implementation=\'org.jacoco.report.check.Limit\'>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<counter>INSTRUCTION</counter>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<value>COVEREDRATIO</value>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<minimum>0.80</minimum>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</limit>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<limit\u00a0implementation=\'org.jacoco.report.check.Limit\'>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<counter>CLASS</counter>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<value>MISSEDCOUNT</value>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<maximum>0</maximum>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</limit>\n\u00a0\u00a0\u00a0\u00a0</limits>\n\u00a0\u00a0</rule>\n</rules>\n\n\nThis example requires a line coverage minimum of 50% for every class except test classes:\n\n<rules>\n\u00a0\u00a0<rule>\n\u00a0\u00a0\u00a0\u00a0<element>CLASS</element>\n\u00a0\u00a0\u00a0\u00a0<excludes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<exclude>*Test</exclude>\n\u00a0\u00a0\u00a0\u00a0</excludes>\n\u00a0\u00a0\u00a0\u00a0<limits>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<limit>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<counter>LINE</counter>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<value>COVEREDRATIO</value>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<minimum>0.50</minimum>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</limit>\n\u00a0\u00a0\u00a0\u00a0</limits>\n\u00a0\u00a0</rule>\n</rules>\n\n", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dump".equals( goal ) )
        {
            append( sb, "jacoco:dump", 0 );
            append( sb, "Request a dump over TCP/IP from a JaCoCo agent running in tcpserver mode.\n\nNote concerning parallel builds: While the dump goal as such is thread safe, it has to be considered that TCP/IP server ports of the agents are a shared resource.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "address", 2 );
                append( sb, "IP address or hostname to connect to.", 3 );
                append( sb, "Expression: ${jacoco.address}", 3 );
                append( sb, "", 0 );

                append( sb, "append (Default: true)", 2 );
                append( sb, "If set to true and the execution data file already exists, coverage data is appended to the existing file. If set to false, an existing execution data file will be replaced.", 3 );
                append( sb, "Expression: ${jacoco.append}", 3 );
                append( sb, "", 0 );

                append( sb, "destFile (Default: ${project.build.directory}/jacoco.exec)", 2 );
                append( sb, "Path to the output file for execution data.", 3 );
                append( sb, "Expression: ${jacoco.destFile}", 3 );
                append( sb, "", 0 );

                append( sb, "dump (Default: true)", 2 );
                append( sb, "Sets whether execution data should be downloaded from the remote host.", 3 );
                append( sb, "Expression: ${jacoco.dump}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "port (Default: 6300)", 2 );
                append( sb, "Port number to connect to. If multiple JaCoCo agents should run on the same machine, different ports have to be specified for the agents.", 3 );
                append( sb, "Expression: ${jacoco.port}", 3 );
                append( sb, "", 0 );

                append( sb, "reset (Default: false)", 2 );
                append( sb, "Sets whether a reset command should be sent after the execution data has been dumped.", 3 );
                append( sb, "Expression: ${jacoco.reset}", 3 );
                append( sb, "", 0 );

                append( sb, "retryCount (Default: 10)", 2 );
                append( sb, "Number of retries which the goal will attempt to establish a connection. This can be used to wait until the target JVM is successfully launched.", 3 );
                append( sb, "Expression: ${jacoco.retryCount}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jacoco:help", 0 );
            append( sb, "Display help information on jacoco-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jacoco:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "instrument".equals( goal ) )
        {
            append( sb, "jacoco:instrument", 0 );
            append( sb, "Performs offline instrumentation. Note that after execution of test you must restore original classes with help of \'restore-instrumented-classes\' goal.\nWarning: The preferred way for code coverage analysis with JaCoCo is on-the-fly instrumentation. Offline instrumentation has several drawbacks and should only be used if a specific scenario explicitly requires this mode. Please consult documentation about offline instrumentation before using this mode.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "merge".equals( goal ) )
        {
            append( sb, "jacoco:merge", 0 );
            append( sb, "Mojo for merging a set of execution data files (*.exec) into a single file", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "destFile (Default: ${project.build.directory}/jacoco.exec)", 2 );
                append( sb, "Path to the output file for execution data.", 3 );
                append( sb, "Expression: ${jacoco.destFile}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "fileSets", 2 );
                append( sb, "This mojo accepts any number of execution data file sets. Note that you need an implementation hint on fileset with Maven 2 (not needed with Maven 3):\n<fileSets>\n\u00a0\u00a0<fileSet\u00a0implementation=\'org.apache.maven.shared.model.fileset.FileSet\'>\n\u00a0\u00a0\u00a0\u00a0<directory>${project.parent.build.directory}</directory>\n\u00a0\u00a0\u00a0\u00a0<includes>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<include>*.exec</include>\n\u00a0\u00a0\u00a0\u00a0</includes>\n\u00a0\u00a0</fileSet>\n</fileSets>\n\n", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jacoco.fileSets}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "prepare-agent".equals( goal ) )
        {
            append( sb, "jacoco:prepare-agent", 0 );
            append( sb, "Prepares a property pointing to the JaCoCo runtime agent that can be passed as a VM argument to the application under test. Depending on the project packaging type by default a property with the following name is set:\n\n-\ttycho.testArgLine for packaging type eclipse-test-plugin and\n-\targLine otherwise.\n\nNote that these properties must not be overwritten by the test configuration, otherwise the JaCoCo agent cannot be attached. If you need custom parameters please append them. For example:\n\n\u00a0\u00a0<argLine>${argLine}\u00a0-your\u00a0-extra\u00a0-arguments</argLine>\n\nResulting coverage information is collected during execution and by default written to a file when the process terminates.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "address", 2 );
                append( sb, "IP address or hostname to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the value \'*\' causes the agent to accept connections on any local address.", 3 );
                append( sb, "Expression: ${jacoco.address}", 3 );
                append( sb, "", 0 );

                append( sb, "append", 2 );
                append( sb, "If set to true and the execution data file already exists, coverage data is appended to the existing file. If set to false, an existing execution data file will be replaced.", 3 );
                append( sb, "Expression: ${jacoco.append}", 3 );
                append( sb, "", 0 );

                append( sb, "classDumpDir", 2 );
                append( sb, "If a directory is specified for this parameter the JaCoCo agent dumps all class files it processes to the given location. This can be useful for debugging purposes or in case of dynamically created classes for example when scripting engines are used.", 3 );
                append( sb, "Expression: ${jacoco.classDumpDir}", 3 );
                append( sb, "", 0 );

                append( sb, "destFile (Default: ${project.build.directory}/jacoco.exec)", 2 );
                append( sb, "Path to the output file for execution data.", 3 );
                append( sb, "Expression: ${jacoco.destFile}", 3 );
                append( sb, "", 0 );

                append( sb, "dumpOnExit", 2 );
                append( sb, "If set to true coverage data will be written on VM shutdown.", 3 );
                append( sb, "Expression: ${jacoco.dumpOnExit}", 3 );
                append( sb, "", 0 );

                append( sb, "exclClassLoaders", 2 );
                append( sb, "A list of class loader names, that should be excluded from execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). This option might be required in case of special frameworks that conflict with JaCoCo code instrumentation, in particular class loaders that do not have access to the Java runtime classes.", 3 );
                append( sb, "Expression: ${jacoco.exclClassLoaders}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "jmx", 2 );
                append( sb, "If set to true the agent exposes functionality via JMX.", 3 );
                append( sb, "Expression: ${jacoco.jmx}", 3 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Output method to use for writing coverage data. Valid options are:\n-\tfile: At VM termination execution data is written to a file.\n-\ttcpserver: The agent listens for incoming connections on the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\ttcpclient: At startup the agent connects to the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\tnone: Do not produce any output.\n", 3 );
                append( sb, "Expression: ${jacoco.output}", 3 );
                append( sb, "", 0 );

                append( sb, "port", 2 );
                append( sb, "Port to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the port must be available, which means that if multiple JaCoCo agents should run on the same machine, different ports have to be specified.", 3 );
                append( sb, "Expression: ${jacoco.port}", 3 );
                append( sb, "", 0 );

                append( sb, "propertyName", 2 );
                append( sb, "Allows to specify property which will contains settings for JaCoCo Agent. If not specified, then \'argLine\' would be used for \'jar\' packaging and \'tycho.testArgLine\' for \'eclipse-test-plugin\'.", 3 );
                append( sb, "Expression: ${jacoco.propertyName}", 3 );
                append( sb, "", 0 );

                append( sb, "sessionId", 2 );
                append( sb, "A session identifier that is written with the execution data. Without this parameter a random identifier is created by the agent.", 3 );
                append( sb, "Expression: ${jacoco.sessionId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "prepare-agent-integration".equals( goal ) )
        {
            append( sb, "jacoco:prepare-agent-integration", 0 );
            append( sb, "Prepares a property pointing to the JaCoCo runtime agent that can be passed as a VM argument to the application under test for integration tests. Depending on the project packaging type by default a property with the following name is set:\n-\ttycho.testArgLine for packaging type eclipse-test-plugin and\n-\targLine otherwise.\nResulting coverage information is collected during execution and by default written to a file when the process terminates.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "address", 2 );
                append( sb, "IP address or hostname to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the value \'*\' causes the agent to accept connections on any local address.", 3 );
                append( sb, "Expression: ${jacoco.address}", 3 );
                append( sb, "", 0 );

                append( sb, "append", 2 );
                append( sb, "If set to true and the execution data file already exists, coverage data is appended to the existing file. If set to false, an existing execution data file will be replaced.", 3 );
                append( sb, "Expression: ${jacoco.append}", 3 );
                append( sb, "", 0 );

                append( sb, "classDumpDir", 2 );
                append( sb, "If a directory is specified for this parameter the JaCoCo agent dumps all class files it processes to the given location. This can be useful for debugging purposes or in case of dynamically created classes for example when scripting engines are used.", 3 );
                append( sb, "Expression: ${jacoco.classDumpDir}", 3 );
                append( sb, "", 0 );

                append( sb, "destFile (Default: ${project.build.directory}/jacoco-it.exec)", 2 );
                append( sb, "Path to the output file for execution data.", 3 );
                append( sb, "Expression: ${jacoco.destFile}", 3 );
                append( sb, "", 0 );

                append( sb, "dumpOnExit", 2 );
                append( sb, "If set to true coverage data will be written on VM shutdown.", 3 );
                append( sb, "Expression: ${jacoco.dumpOnExit}", 3 );
                append( sb, "", 0 );

                append( sb, "exclClassLoaders", 2 );
                append( sb, "A list of class loader names, that should be excluded from execution analysis. The list entries are separated by a colon (:) and may use wildcard characters (* and ?). This option might be required in case of special frameworks that conflict with JaCoCo code instrumentation, in particular class loaders that do not have access to the Java runtime classes.", 3 );
                append( sb, "Expression: ${jacoco.exclClassLoaders}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "jmx", 2 );
                append( sb, "If set to true the agent exposes functionality via JMX.", 3 );
                append( sb, "Expression: ${jacoco.jmx}", 3 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Output method to use for writing coverage data. Valid options are:\n-\tfile: At VM termination execution data is written to a file.\n-\ttcpserver: The agent listens for incoming connections on the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\ttcpclient: At startup the agent connects to the TCP port specified by the address and port. Execution data is written to this TCP connection.\n-\tnone: Do not produce any output.\n", 3 );
                append( sb, "Expression: ${jacoco.output}", 3 );
                append( sb, "", 0 );

                append( sb, "port", 2 );
                append( sb, "Port to bind to when the output method is tcpserver or connect to when the output method is tcpclient. In tcpserver mode the port must be available, which means that if multiple JaCoCo agents should run on the same machine, different ports have to be specified.", 3 );
                append( sb, "Expression: ${jacoco.port}", 3 );
                append( sb, "", 0 );

                append( sb, "propertyName", 2 );
                append( sb, "Allows to specify property which will contains settings for JaCoCo Agent. If not specified, then \'argLine\' would be used for \'jar\' packaging and \'tycho.testArgLine\' for \'eclipse-test-plugin\'.", 3 );
                append( sb, "Expression: ${jacoco.propertyName}", 3 );
                append( sb, "", 0 );

                append( sb, "sessionId", 2 );
                append( sb, "A session identifier that is written with the execution data. Without this parameter a random identifier is created by the agent.", 3 );
                append( sb, "Expression: ${jacoco.sessionId}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report".equals( goal ) )
        {
            append( sb, "jacoco:report", 0 );
            append( sb, "Creates a code coverage report for tests of a single project in multiple formats (HTML, XML, and CSV).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataFile (Default: ${project.build.directory}/jacoco.exec)", 2 );
                append( sb, "File with execution data.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from the report. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in the report. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/jacoco)", 2 );
                append( sb, "Output directory for the reports. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: UTF-8)", 2 );
                append( sb, "Encoding of the generated reports.", 3 );
                append( sb, "Expression: ${project.reporting.outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: UTF-8)", 2 );
                append( sb, "Encoding of the source files.", 3 );
                append( sb, "Expression: ${project.build.sourceEncoding}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "report-integration".equals( goal ) )
        {
            append( sb, "jacoco:report-integration", 0 );
            append( sb, "Creates a code coverage report for integration tests of a single project in multiple formats (HTML, XML, and CSV).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dataFile (Default: ${project.build.directory}/jacoco-it.exec)", 2 );
                append( sb, "File with execution data.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from the report. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in the report. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/jacoco-it)", 2 );
                append( sb, "Output directory for the reports. Note that this parameter is only relevant if the goal is run from the command line or from the default build lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: UTF-8)", 2 );
                append( sb, "Encoding of the generated reports.", 3 );
                append( sb, "Expression: ${project.reporting.outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: UTF-8)", 2 );
                append( sb, "Encoding of the source files.", 3 );
                append( sb, "Expression: ${project.build.sourceEncoding}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "restore-instrumented-classes".equals( goal ) )
        {
            append( sb, "jacoco:restore-instrumented-classes", 0 );
            append( sb, "Restores original classes as they were before offline instrumentation.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of class files to exclude from instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified nothing will be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of class files to include in instrumentation/analysis/reports. May use wildcard characters (* and ?). When not specified everything will be included.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag used to suppress execution.", 3 );
                append( sb, "Expression: ${jacoco.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
