/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.maven.FileFilter;

@Mojo(name="instrument", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class InstrumentMojo
extends AbstractJacocoMojo {
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;

    @Override
    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        List<String> fileNames;
        File originalClassesDir = new File(this.getProject().getBuild().getDirectory(), "generated-classes/jacoco");
        originalClassesDir.mkdirs();
        File classesDir = new File(this.getProject().getBuild().getOutputDirectory());
        if (!classesDir.exists()) {
            this.getLog().info((CharSequence)("Skipping JaCoCo execution due to missing classes directory:" + classesDir));
            return;
        }
        try {
            fileNames = new FileFilter(this.includes, this.excludes).getFileNames(classesDir);
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Unable to get list of files to instrument.", (Exception)e1);
        }
        Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
        for (String fileName : fileNames) {
            if (!fileName.endsWith(".class")) continue;
            File source = new File(classesDir, fileName);
            File backup = new File(originalClassesDir, fileName);
            FileInputStream input = null;
            FileOutputStream output = null;
            try {
                FileUtils.copyFile((File)source, (File)backup);
                input = new FileInputStream(backup);
                output = new FileOutputStream(source);
                instrumenter.instrument((InputStream)input, (OutputStream)output, source.getPath());
            }
            catch (IOException e2) {
                try {
                    throw new MojoExecutionException("Unable to instrument file.", (Exception)e2);
                }
                catch (Throwable throwable) {
                    IOUtil.close(input);
                    IOUtil.close(output);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)input);
            IOUtil.close((OutputStream)output);
        }
    }
}

