/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_jzhc14.core.internal.instr;

import org.jacoco.agent.rt_jzhc14.asm.ClassAdapter;
import org.jacoco.agent.rt_jzhc14.asm.ClassVisitor;
import org.jacoco.agent.rt_jzhc14.asm.FieldVisitor;
import org.jacoco.agent.rt_jzhc14.asm.Label;
import org.jacoco.agent.rt_jzhc14.asm.MethodVisitor;
import org.jacoco.agent.rt_jzhc14.core.internal.flow.IClassProbesVisitor;
import org.jacoco.agent.rt_jzhc14.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.agent.rt_jzhc14.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt_jzhc14.core.internal.instr.MethodInstrumenter;
import org.jacoco.agent.rt_jzhc14.core.runtime.IExecutionDataAccessorGenerator;

public class ClassInstrumenter
extends ClassAdapter
implements IClassProbesVisitor {
    private static final Object[] STACK_ARRZ = new Object[]{"[Z"};
    private static final Object[] NO_LOCALS = new Object[0];
    private final long id;
    private final IExecutionDataAccessorGenerator accessorGenerator;
    private IProbeArrayStrategy probeArrayStrategy;
    private String className;
    private int probeCount;

    public ClassInstrumenter(long id, IExecutionDataAccessorGenerator accessorGenerator, ClassVisitor cv) {
        super(cv);
        this.id = id;
        this.accessorGenerator = accessorGenerator;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.probeArrayStrategy = (access & 0x200) == 0 ? new ClassTypeStrategy() : new InterfaceTypeStrategy();
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.assertNotInstrumented(name, "$jacocoData");
        return super.visitField(access, name, desc, signature, value);
    }

    public IMethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.assertNotInstrumented(name, "$jacocoInit");
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        return new MethodInstrumenter(mv, access, desc, this.probeArrayStrategy);
    }

    public void visitTotalProbeCount(int count) {
        this.probeCount = count;
    }

    public void visitEnd() {
        this.probeArrayStrategy.addMembers(this.cv);
        super.visitEnd();
    }

    private void assertNotInstrumented(String member, String instrMember) throws IllegalStateException {
        if (member.equals(instrMember)) {
            throw new IllegalStateException(String.format("Class %s is already instrumented.", this.className));
        }
    }

    private class ClassTypeStrategy
    implements IProbeArrayStrategy {
        private ClassTypeStrategy() {
        }

        public int pushInstance(MethodVisitor mv) {
            mv.visitMethodInsn(184, ClassInstrumenter.this.className, "$jacocoInit", "()[Z");
            return 1;
        }

        public void addMembers(ClassVisitor delegate) {
            this.createDataField();
            this.createInitMethod(ClassInstrumenter.this.probeCount);
        }

        private void createDataField() {
            ClassInstrumenter.this.cv.visitField(4250, "$jacocoData", "[Z", null, null);
        }

        private void createInitMethod(int probeCount) {
            MethodVisitor mv = ClassInstrumenter.this.cv.visitMethod(4122, "$jacocoInit", "()[Z", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, ClassInstrumenter.this.className, "$jacocoData", "[Z");
            mv.visitInsn(89);
            Label alreadyInitialized = new Label();
            mv.visitJumpInsn(199, alreadyInitialized);
            mv.visitInsn(87);
            int size = this.genInitializeDataField(mv, probeCount);
            mv.visitFrame(0, 0, NO_LOCALS, 1, STACK_ARRZ);
            mv.visitLabel(alreadyInitialized);
            mv.visitInsn(176);
            mv.visitMaxs(Math.max(size, 2), 0);
            mv.visitEnd();
        }

        private int genInitializeDataField(MethodVisitor mv, int probeCount) {
            int size = ClassInstrumenter.this.accessorGenerator.generateDataAccessor(ClassInstrumenter.this.id, ClassInstrumenter.this.className, probeCount, mv);
            mv.visitInsn(89);
            mv.visitFieldInsn(179, ClassInstrumenter.this.className, "$jacocoData", "[Z");
            return Math.max(size, 2);
        }
    }

    private class InterfaceTypeStrategy
    implements IProbeArrayStrategy {
        private InterfaceTypeStrategy() {
        }

        public int pushInstance(MethodVisitor mv) {
            return ClassInstrumenter.this.accessorGenerator.generateDataAccessor(ClassInstrumenter.this.id, ClassInstrumenter.this.className, ClassInstrumenter.this.probeCount, mv);
        }

        public void addMembers(ClassVisitor delegate) {
        }
    }
}

