/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_1r70et.controller;

import java.io.IOException;
import java.net.Socket;
import org.jacoco.agent.rt_1r70et.IExceptionLogger;
import org.jacoco.agent.rt_1r70et.controller.IAgentController;
import org.jacoco.agent.rt_1r70et.controller.TcpConnection;
import org.jacoco.agent.rt_1r70et.core.runtime.AgentOptions;
import org.jacoco.agent.rt_1r70et.core.runtime.IRuntime;

public class TcpClientController
implements IAgentController {
    private final IExceptionLogger logger;
    private TcpConnection connection;
    private Thread worker;

    public TcpClientController(IExceptionLogger logger) {
        this.logger = logger;
    }

    public void startup(AgentOptions options, IRuntime runtime) throws IOException {
        Socket socket = this.createSocket(options);
        this.connection = new TcpConnection(socket, runtime);
        this.connection.init();
        this.worker = new Thread(new Runnable(){

            public void run() {
                try {
                    TcpClientController.this.connection.run();
                }
                catch (IOException e) {
                    TcpClientController.this.logger.logExeption(e);
                }
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void shutdown() throws Exception {
        this.connection.close();
        this.worker.join();
    }

    public void writeExecutionData() throws IOException {
        this.connection.writeExecutionData();
    }

    protected Socket createSocket(AgentOptions options) throws IOException {
        return new Socket(options.getAddress(), options.getPort());
    }
}

