/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt_1r70et.core.internal.instr;

import org.jacoco.agent.rt_1r70et.asm.Label;
import org.jacoco.agent.rt_1r70et.asm.MethodAdapter;
import org.jacoco.agent.rt_1r70et.asm.MethodVisitor;
import org.jacoco.agent.rt_1r70et.asm.Opcodes;
import org.jacoco.agent.rt_1r70et.asm.Type;
import org.jacoco.agent.rt_1r70et.asm.tree.InsnList;
import org.jacoco.agent.rt_1r70et.asm.tree.LabelNode;
import org.jacoco.agent.rt_1r70et.asm.tree.LineNumberNode;
import org.jacoco.agent.rt_1r70et.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.agent.rt_1r70et.core.internal.instr.IProbeInserter;
import org.jacoco.agent.rt_1r70et.core.internal.instr.InstrSupport;

class ProbeInserter
extends MethodAdapter
implements IProbeInserter {
    private final IProbeArrayStrategy arrayStrategy;
    private final int variable;
    private final int variableIdx;
    private boolean inserted;
    private int accessorStackSize;
    private final InsnList prolog;

    ProbeInserter(int access, String desc, MethodVisitor mv, IProbeArrayStrategy arrayStrategy) {
        super(mv);
        int idx;
        this.arrayStrategy = arrayStrategy;
        int pos = idx = (8 & access) == 0 ? 1 : 0;
        Type[] typeArray = Type.getArgumentTypes(desc);
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            ++idx;
            pos += t.getSize();
            ++n2;
        }
        this.variableIdx = idx;
        this.variable = pos;
        this.inserted = false;
        this.prolog = new InsnList();
    }

    public void insertProbe(int id) {
        this.checkLoad();
        this.mv.visitVarInsn(25, this.variable);
        InstrSupport.push(this.mv, id);
        this.mv.visitInsn(4);
        this.mv.visitInsn(84);
    }

    private void checkLoad() {
        if (!this.inserted) {
            this.accessorStackSize = this.arrayStrategy.storeInstance(this.mv, this.variable);
            this.prolog.accept(this.mv);
            this.inserted = true;
        }
    }

    public final void visitLabel(Label label) {
        if (!this.inserted) {
            this.prolog.add(new LabelNode(label));
        } else {
            this.mv.visitLabel(label);
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (!this.inserted) {
            this.prolog.add(new LineNumberNode(line, new LabelNode(start)));
        } else {
            this.mv.visitLineNumber(line, start);
        }
    }

    public final void visitVarInsn(int opcode, int var) {
        this.checkLoad();
        this.mv.visitVarInsn(opcode, this.map(var));
    }

    public final void visitIincInsn(int var, int increment) {
        this.checkLoad();
        this.mv.visitIincInsn(this.map(var), increment);
    }

    public final void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.checkLoad();
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.map(index));
    }

    public final void visitInsn(int opcode) {
        this.checkLoad();
        this.mv.visitInsn(opcode);
    }

    public final void visitIntInsn(int opcode, int operand) {
        this.checkLoad();
        this.mv.visitIntInsn(opcode, operand);
    }

    public final void visitTypeInsn(int opcode, String type) {
        this.checkLoad();
        this.mv.visitTypeInsn(opcode, type);
    }

    public final void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.checkLoad();
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public final void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.checkLoad();
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public final void visitJumpInsn(int opcode, Label label) {
        this.checkLoad();
        this.mv.visitJumpInsn(opcode, label);
    }

    public final void visitLdcInsn(Object cst) {
        this.checkLoad();
        this.mv.visitLdcInsn(cst);
    }

    public final void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.checkLoad();
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public final void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkLoad();
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public final void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkLoad();
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        int increasedStack = Math.max(maxStack + 3, this.accessorStackSize);
        this.mv.visitMaxs(increasedStack, maxLocals + 1);
    }

    private int map(int var) {
        if (var < this.variable) {
            return var;
        }
        return var + 1;
    }

    public final void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1) {
            throw new IllegalArgumentException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (this.inserted) {
            int n = Math.max(nLocal, this.variableIdx) + 1;
            Object[] newLocal = new Object[n];
            int i = 0;
            while (i < n) {
                newLocal[i] = i < this.variableIdx ? (i < nLocal ? local[i] : Opcodes.TOP) : (i > this.variableIdx ? local[i - 1] : "[Z");
                ++i;
            }
            this.mv.visitFrame(type, n, newLocal, nStack, stack);
        } else {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
        }
        this.checkLoad();
    }
}

