/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class AgentJar {
    private static final String RESOURCE = "/jacocoagent.jar";
    private static final String ERRORMSG = String.format("The resource %s has not been found. Please see /org.jacoco.agent/README.TXT for details.", "/jacocoagent.jar");

    private AgentJar() {
    }

    public static URL getResource() {
        URL url = AgentJar.class.getResource(RESOURCE);
        if (url == null) {
            throw new AssertionError((Object)ERRORMSG);
        }
        return url;
    }

    public static InputStream getResourceAsStream() {
        InputStream stream = AgentJar.class.getResourceAsStream(RESOURCE);
        if (stream == null) {
            throw new AssertionError((Object)ERRORMSG);
        }
        return stream;
    }

    public static File extractToTempLocation() throws IOException {
        File agentJar = File.createTempFile("jacocoagent", ".jar");
        agentJar.deleteOnExit();
        AgentJar.extractTo(agentJar);
        return agentJar;
    }

    public static void extractTo(File destination) throws IOException {
        InputStream inputJarStream = AgentJar.getResourceAsStream();
        FileOutputStream outputJarStream = null;
        try {
            int bytesRead;
            outputJarStream = new FileOutputStream(destination);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputJarStream.read(buffer)) != -1) {
                ((OutputStream)outputJarStream).write(buffer, 0, bytesRead);
            }
        }
        finally {
            AgentJar.safeClose(inputJarStream);
            AgentJar.safeClose(outputJarStream);
        }
    }

    private static void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }
}

