/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_6da5971.output;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.jacoco.agent.rt.internal_6da5971.IExceptionLogger;
import org.jacoco.agent.rt.internal_6da5971.core.runtime.AgentOptions;
import org.jacoco.agent.rt.internal_6da5971.core.runtime.RuntimeData;
import org.jacoco.agent.rt.internal_6da5971.output.IAgentOutput;
import org.jacoco.agent.rt.internal_6da5971.output.TcpConnection;

public class TcpServerOutput
implements IAgentOutput {
    private TcpConnection connection;
    private final IExceptionLogger logger;
    private ServerSocket serverSocket;
    private Thread worker;

    public TcpServerOutput(IExceptionLogger logger) {
        this.logger = logger;
    }

    public void startup(AgentOptions options, final RuntimeData data) throws IOException {
        this.serverSocket = this.createServerSocket(options);
        this.worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!TcpServerOutput.this.serverSocket.isClosed()) {
                    try {
                        ServerSocket serverSocket = TcpServerOutput.this.serverSocket;
                        synchronized (serverSocket) {
                            TcpServerOutput.this.connection = new TcpConnection(TcpServerOutput.this.serverSocket.accept(), data);
                        }
                        TcpServerOutput.this.connection.init();
                        TcpServerOutput.this.connection.run();
                    }
                    catch (IOException e) {
                        if (TcpServerOutput.this.serverSocket.isClosed()) continue;
                        TcpServerOutput.this.logger.logExeption(e);
                    }
                }
            }
        });
        this.worker.setName(this.getClass().getName());
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        this.serverSocket.close();
        ServerSocket serverSocket = this.serverSocket;
        synchronized (serverSocket) {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.worker.join();
    }

    public void writeExecutionData(boolean reset) throws IOException {
        if (this.connection != null) {
            this.connection.writeExecutionData(reset);
        }
    }

    protected ServerSocket createServerSocket(AgentOptions options) throws IOException {
        InetAddress inetAddr = this.getInetAddress(options.getAddress());
        return new ServerSocket(options.getPort(), 1, inetAddr);
    }

    protected InetAddress getInetAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            return null;
        }
        return InetAddress.getByName(address);
    }
}

