/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.JumpInsnNode;
import org.jacoco.cli.internal.asm.tree.LabelNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.VarInsnNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KotlinSafeCallOperatorFilter
implements IFilter {
    KotlinSafeCallOperatorFilter() {
    }

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        for (ArrayList<JumpInsnNode> chain : KotlinSafeCallOperatorFilter.findChains(methodNode)) {
            if (chain.size() == 1) continue;
            JumpInsnNode lastJump = chain.get(chain.size() - 1);
            HashSet<AbstractInsnNode> newTargets = new HashSet<AbstractInsnNode>();
            newTargets.add(AbstractMatcher.skipNonOpcodes(lastJump.getNext()));
            newTargets.add(AbstractMatcher.skipNonOpcodes(lastJump.label));
            for (JumpInsnNode i : chain) {
                output.replaceBranches(i, newTargets);
            }
        }
    }

    private static Collection<ArrayList<JumpInsnNode>> findChains(MethodNode methodNode) {
        HashMap<LabelNode, ArrayList<JumpInsnNode>> chains = new HashMap<LabelNode, ArrayList<JumpInsnNode>>();
        for (AbstractInsnNode i : methodNode.instructions) {
            AbstractInsnNode p1;
            AbstractInsnNode p2;
            if (i.getOpcode() != 198) continue;
            JumpInsnNode jump = (JumpInsnNode)i;
            LabelNode label = jump.label;
            AbstractInsnNode target = AbstractMatcher.skipNonOpcodes(label);
            ArrayList<JumpInsnNode> chain = (ArrayList<JumpInsnNode>)chains.get(label);
            if (target.getOpcode() != 87 ? target.getOpcode() != 1 || i.getPrevious().getOpcode() != 25 || chain != null && ((p2 = (p1 = i.getPrevious()).getPrevious()) == null || p2.getOpcode() != 58 || ((VarInsnNode)p1).var != ((VarInsnNode)p2).var) : i.getPrevious().getOpcode() != 89) continue;
            if (chain == null) {
                chain = new ArrayList<JumpInsnNode>();
                chains.put(label, chain);
            }
            chain.add(jump);
        }
        return chains.values();
    }
}

