/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import java.util.ArrayList;
import java.util.Iterator;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.JumpInsnNode;
import org.jacoco.cli.internal.asm.tree.LdcInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.TableSwitchInsnNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;

final class KotlinCoroutineFilter
implements IFilter {
    KotlinCoroutineFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        new Matcher().match(methodNode, output);
        new Matcher().matchOptimizedTailCall(methodNode, output);
        new Matcher().matchSuspendCoroutineUninterceptedOrReturn(methodNode, output);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        private void matchSuspendCoroutineUninterceptedOrReturn(MethodNode methodNode, IFilterOutput output) {
            Iterator i$ = methodNode.instructions.iterator();
            while (i$.hasNext()) {
                AbstractInsnNode i;
                this.cursor = i = (AbstractInsnNode)i$.next();
                this.nextIs(89);
                this.nextIsInvoke(184, "kotlin/coroutines/intrinsics/IntrinsicsKt", "getCOROUTINE_SUSPENDED", "()Ljava/lang/Object;");
                this.nextIs(166);
                JumpInsnNode jumpInstruction = (JumpInsnNode)this.cursor;
                this.nextIs(25);
                if (this.cursor != null && this.cursor.getNext().getOpcode() == 192) {
                    this.nextIsType(192, "kotlin/coroutines/Continuation");
                }
                this.nextIsInvoke(184, "kotlin/coroutines/jvm/internal/DebugProbesKt", "probeCoroutineSuspended", "(Lkotlin/coroutines/Continuation;)V");
                if (this.cursor == null || jumpInstruction.label != this.cursor.getNext()) continue;
                output.ignore(jumpInstruction, this.cursor);
            }
        }

        private void matchOptimizedTailCall(MethodNode methodNode, IFilterOutput output) {
            Iterator i$ = methodNode.instructions.iterator();
            while (i$.hasNext()) {
                AbstractInsnNode i;
                this.cursor = i = (AbstractInsnNode)i$.next();
                this.nextIs(89);
                this.nextIsInvoke(184, "kotlin/coroutines/intrinsics/IntrinsicsKt", "getCOROUTINE_SUSPENDED", "()Ljava/lang/Object;");
                this.nextIs(166);
                this.nextIs(176);
                this.nextIs(87);
                if (this.cursor == null) continue;
                output.ignore(i.getNext(), this.cursor);
            }
        }

        private void match(MethodNode methodNode, IFilterOutput output) {
            TableSwitchInsnNode s;
            this.cursor = methodNode.instructions.getFirst();
            while (this.cursor != null) {
                if (this.cursor.getOpcode() == 184) {
                    MethodInsnNode m = (MethodInsnNode)this.cursor;
                    if ("kotlin/coroutines/intrinsics/IntrinsicsKt".equals(m.owner) && "getCOROUTINE_SUSPENDED".equals(m.name) && "()Ljava/lang/Object;".equals(m.desc)) break;
                }
                this.cursor = this.cursor.getNext();
            }
            if (this.cursor == null) {
                return;
            }
            if (87 == Matcher.skipNonOpcodes(this.cursor.getNext()).getOpcode()) {
                this.nextIs(87);
                s = this.nextIsStateSwitch();
                if (s == null || s.labels.size() != 1) {
                    return;
                }
            } else {
                this.nextIsVar(58, "COROUTINE_SUSPENDED");
                s = this.nextIsStateSwitch();
                if (s == null) {
                    return;
                }
            }
            ArrayList<AbstractInsnNode> ignore = new ArrayList<AbstractInsnNode>(s.labels.size() * 2);
            this.nextIs(25);
            this.nextIsThrowOnFailure();
            if (this.cursor == null) {
                return;
            }
            ignore.add(methodNode.instructions.getFirst());
            ignore.add(this.cursor);
            int suspensionPoint = 1;
            for (AbstractInsnNode i = this.cursor; i != null && suspensionPoint < s.labels.size(); i = i.getNext()) {
                this.cursor = i;
                this.nextIsVar(25, "COROUTINE_SUSPENDED");
                this.nextIs(166);
                JumpInsnNode jumpToContinuationAfterLoadedResult = (JumpInsnNode)this.cursor;
                this.nextIsVar(25, "COROUTINE_SUSPENDED");
                this.nextIs(176);
                if (this.cursor == null || Matcher.skipNonOpcodes(this.cursor.getNext()) != Matcher.skipNonOpcodes(s.labels.get(suspensionPoint))) continue;
                ignore.add(i);
                ignore.add(jumpToContinuationAfterLoadedResult.label.getPrevious());
                ++suspensionPoint;
            }
            this.cursor = s.dflt;
            this.nextIsType(187, "java/lang/IllegalStateException");
            this.nextIs(89);
            this.nextIs(18);
            if (this.cursor == null) {
                return;
            }
            if (!((LdcInsnNode)this.cursor).cst.equals("call to 'resume' before 'invoke' with coroutine")) {
                return;
            }
            this.nextIsInvoke(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            this.nextIs(191);
            if (this.cursor == null) {
                return;
            }
            output.ignore(s.dflt, this.cursor);
            for (int i = 0; i < ignore.size(); i += 2) {
                output.ignore((AbstractInsnNode)ignore.get(i), (AbstractInsnNode)ignore.get(i + 1));
            }
        }

        private TableSwitchInsnNode nextIsStateSwitch() {
            this.nextIsVar(25, "this");
            this.nextIs(180);
            this.nextIs(170);
            if (this.cursor == null) {
                return null;
            }
            return (TableSwitchInsnNode)this.cursor;
        }

        private void nextIsThrowOnFailure() {
            AbstractInsnNode c = this.cursor;
            this.nextIsInvoke(184, "kotlin/ResultKt", "throwOnFailure", "(Ljava/lang/Object;)V");
            if (this.cursor == null) {
                this.cursor = c;
                this.nextIs(89);
                this.nextIsType(193, "kotlin/Result$Failure");
                this.nextIs(153);
                this.nextIsType(192, "kotlin/Result$Failure");
                this.nextIs(180);
                this.nextIs(191);
                this.nextIs(87);
            }
        }
    }
}

