/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.FieldInsnNode;
import org.jacoco.cli.internal.asm.tree.JumpInsnNode;
import org.jacoco.cli.internal.asm.tree.LabelNode;
import org.jacoco.cli.internal.asm.tree.LookupSwitchInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.TableSwitchInsnNode;
import org.jacoco.cli.internal.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilter;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterContext;
import org.jacoco.cli.internal.core.internal.analysis.filter.IFilterOutput;
import org.jacoco.cli.internal.core.internal.analysis.filter.Replacements;

final class KotlinWhenFilter
implements IFilter {
    private static final String EXCEPTION = "kotlin/NoWhenBranchMatchedException";

    KotlinWhenFilter() {
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i : methodNode.instructions) {
            matcher.match(i, output);
            matcher.matchNullableEnum(i, output);
        }
    }

    private static LabelNode getDefaultLabel(AbstractInsnNode i) {
        switch (i.getOpcode()) {
            case 171: {
                return ((LookupSwitchInsnNode)i).dflt;
            }
            case 170: {
                return ((TableSwitchInsnNode)i).dflt;
            }
        }
        return null;
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        void match(AbstractInsnNode start, IFilterOutput output) {
            if (start.getType() != 8) {
                return;
            }
            this.cursor = start;
            this.nextIsType(187, KotlinWhenFilter.EXCEPTION);
            this.nextIs(89);
            this.nextIsInvoke(183, KotlinWhenFilter.EXCEPTION, "<init>", "()V");
            this.nextIs(191);
            for (AbstractInsnNode i = this.cursor; i != null; i = i.getPrevious()) {
                if (i.getOpcode() == 153 && ((JumpInsnNode)i).label == start) {
                    output.ignore(i, i);
                    output.ignore(start, this.cursor);
                    return;
                }
                if (KotlinWhenFilter.getDefaultLabel(i) != start) continue;
                output.replaceBranches(i, Replacements.ignoreDefaultBranch(i));
                output.ignore(start, this.cursor);
                return;
            }
        }

        void matchNullableEnum(AbstractInsnNode start, IFilterOutput output) {
            if (start.getOpcode() != 89) {
                return;
            }
            this.cursor = start;
            this.nextIs(199);
            JumpInsnNode jump1 = (JumpInsnNode)this.cursor;
            this.nextIs(87);
            this.nextIs(2);
            this.nextIs(167);
            JumpInsnNode jump2 = (JumpInsnNode)this.cursor;
            this.nextIs(178);
            FieldInsnNode fieldInsnNode = (FieldInsnNode)this.cursor;
            if (fieldInsnNode == null || !fieldInsnNode.owner.endsWith("$WhenMappings") || !fieldInsnNode.name.startsWith("$EnumSwitchMapping$")) {
                return;
            }
            this.nextIs(95);
            this.nextIs(182);
            this.nextIs(46);
            this.nextIsSwitch();
            if (this.cursor != null && Matcher.skipNonOpcodes(jump1.label) == Matcher.skipNonOpcodes(jump2.getNext()) && Matcher.skipNonOpcodes(jump2.label) == this.cursor) {
                output.ignore(start, this.cursor.getPrevious());
            }
        }
    }
}

