/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jacodb.analysis.engine.AnalysisDependentEvent;
import org.jacodb.analysis.engine.Analyzer;
import org.jacodb.analysis.engine.CrossUnitCallFact;
import org.jacodb.analysis.engine.EdgeForOtherRunnerQuery;
import org.jacodb.analysis.engine.IfdsEdge;
import org.jacodb.analysis.engine.IfdsResult;
import org.jacodb.analysis.engine.IfdsVertex;
import org.jacodb.analysis.engine.NewSummaryFact;
import org.jacodb.analysis.engine.SummaryEdgeFact;
import org.jacodb.analysis.engine.TraceGraph;
import org.jacodb.analysis.engine.TraceGraphFact;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jacodb/analysis/engine/AbstractAnalyzer;", "Lorg/jacodb/analysis/engine/Analyzer;", "graph", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "(Lorg/jacodb/api/analysis/JcApplicationGraph;)V", "isMainAnalyzer", "", "()Z", "verticesWithTraceGraphNeeded", "", "Lorg/jacodb/analysis/engine/IfdsVertex;", "getVerticesWithTraceGraphNeeded", "()Ljava/util/Set;", "handleIfdsResult", "", "Lorg/jacodb/analysis/engine/AnalysisDependentEvent;", "ifdsResult", "Lorg/jacodb/analysis/engine/IfdsResult;", "handleNewCrossUnitCall", "fact", "Lorg/jacodb/analysis/engine/CrossUnitCallFact;", "handleNewEdge", "edge", "Lorg/jacodb/analysis/engine/IfdsEdge;", "jacodb-analysis"})
public abstract class AbstractAnalyzer
implements Analyzer {
    @NotNull
    private final JcApplicationGraph graph;
    @NotNull
    private final Set<IfdsVertex> verticesWithTraceGraphNeeded;

    public AbstractAnalyzer(@NotNull JcApplicationGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet()");
        this.verticesWithTraceGraphNeeded = keySetView;
    }

    @NotNull
    protected final Set<IfdsVertex> getVerticesWithTraceGraphNeeded() {
        return this.verticesWithTraceGraphNeeded;
    }

    public abstract boolean isMainAnalyzer();

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleNewEdge(@NotNull IfdsEdge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        return this.isMainAnalyzer() && SequencesKt.contains((Sequence)this.graph.exitPoints((Object)edge.getMethod()), (Object)edge.getV().getStatement()) ? CollectionsKt.listOf((Object)new NewSummaryFact(new SummaryEdgeFact(edge))) : CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleNewCrossUnitCall(@NotNull CrossUnitCallFact fact) {
        List list;
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        if (this.isMainAnalyzer()) {
            this.verticesWithTraceGraphNeeded.add(fact.getCallerVertex());
            Object[] objectArray = new AnalysisDependentEvent[]{new NewSummaryFact(fact), new EdgeForOtherRunnerQuery(new IfdsEdge(fact.getCalleeVertex(), fact.getCalleeVertex()))};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleIfdsResult(@NotNull IfdsResult ifdsResult2) {
        TraceGraph it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ifdsResult2, (String)"ifdsResult");
        Iterable $this$map$iv = this.verticesWithTraceGraphNeeded;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IfdsVertex ifdsVertex = (IfdsVertex)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ifdsResult2.resolveTraceGraph((IfdsVertex)((Object)it)));
        }
        List traceGraphs = (List)destination$iv$iv;
        $this$map$iv = traceGraphs;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (TraceGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NewSummaryFact(new TraceGraphFact(it)));
        }
        return (List)destination$iv$iv;
    }
}

