/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.IfdsEdge;
import org.jacodb.analysis.engine.IfdsVertex;
import org.jacodb.analysis.engine.PathEdgePredecessor;
import org.jacodb.analysis.engine.PredecessorKind;
import org.jacodb.analysis.engine.TraceGraph;
import org.jacodb.analysis.engine.ZEROFact;
import org.jacodb.api.cfg.JcInst;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jacodb/analysis/engine/IfdsResult;", "", "pathEdges", "", "Lorg/jacodb/analysis/engine/IfdsEdge;", "resultFacts", "", "Lorg/jacodb/api/cfg/JcInst;", "", "Lorg/jacodb/analysis/engine/DomainFact;", "pathEdgesPreds", "Lorg/jacodb/analysis/engine/PathEdgePredecessor;", "(Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "getPathEdges", "()Ljava/util/List;", "getPathEdgesPreds", "()Ljava/util/Map;", "getResultFacts", "resolveTraceGraph", "Lorg/jacodb/analysis/engine/TraceGraph;", "vertex", "Lorg/jacodb/analysis/engine/IfdsVertex;", "TraceGraphBuilder", "jacodb-analysis"})
public final class IfdsResult {
    @NotNull
    private final List<IfdsEdge> pathEdges;
    @NotNull
    private final Map<JcInst, Set<DomainFact>> resultFacts;
    @NotNull
    private final Map<IfdsEdge, Set<PathEdgePredecessor>> pathEdgesPreds;

    public IfdsResult(@NotNull List<IfdsEdge> pathEdges, @NotNull Map<JcInst, ? extends Set<? extends DomainFact>> resultFacts, @NotNull Map<IfdsEdge, ? extends Set<PathEdgePredecessor>> pathEdgesPreds) {
        Intrinsics.checkNotNullParameter(pathEdges, (String)"pathEdges");
        Intrinsics.checkNotNullParameter(resultFacts, (String)"resultFacts");
        Intrinsics.checkNotNullParameter(pathEdgesPreds, (String)"pathEdgesPreds");
        this.pathEdges = pathEdges;
        this.resultFacts = resultFacts;
        this.pathEdgesPreds = pathEdgesPreds;
    }

    @NotNull
    public final List<IfdsEdge> getPathEdges() {
        return this.pathEdges;
    }

    @NotNull
    public final Map<JcInst, Set<DomainFact>> getResultFacts() {
        return this.resultFacts;
    }

    @NotNull
    public final Map<IfdsEdge, Set<PathEdgePredecessor>> getPathEdgesPreds() {
        return this.pathEdgesPreds;
    }

    @NotNull
    public final TraceGraph resolveTraceGraph(@NotNull IfdsVertex vertex) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        return new TraceGraphBuilder(vertex).build();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jacodb/analysis/engine/IfdsResult$TraceGraphBuilder;", "", "sink", "Lorg/jacodb/analysis/engine/IfdsVertex;", "(Lorg/jacodb/analysis/engine/IfdsResult;Lorg/jacodb/analysis/engine/IfdsVertex;)V", "edges", "", "", "sources", "visited", "Lorg/jacodb/analysis/engine/IfdsEdge;", "addEdge", "", "from", "to", "build", "Lorg/jacodb/analysis/engine/TraceGraph;", "dfs", "e", "lastVertex", "stopAtMethodStart", "", "jacodb-analysis"})
    private final class TraceGraphBuilder {
        @NotNull
        private final IfdsVertex sink;
        @NotNull
        private final Set<IfdsVertex> sources;
        @NotNull
        private final Map<IfdsVertex, Set<IfdsVertex>> edges;
        @NotNull
        private final Set<IfdsEdge> visited;

        public TraceGraphBuilder(IfdsVertex sink) {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.sink = sink;
            this.sources = new LinkedHashSet();
            this.edges = new LinkedHashMap();
            this.visited = new LinkedHashSet();
        }

        private final void addEdge(IfdsVertex from, IfdsVertex to) {
            if (!Intrinsics.areEqual((Object)from, (Object)to)) {
                Set set;
                Map<IfdsVertex, Set<IfdsVertex>> $this$getOrPut$iv = this.edges;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(from);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(from, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((IfdsVertex)to);
            }
        }

        private final void dfs(IfdsEdge e, IfdsVertex lastVertex, boolean stopAtMethodStart) {
            if (this.visited.contains(e)) {
                return;
            }
            this.visited.add(e);
            if (stopAtMethodStart && Intrinsics.areEqual((Object)e.getU(), (Object)e.getV())) {
                this.addEdge(e.getU(), lastVertex);
                return;
            }
            IfdsVertex v = e.component2();
            if (Intrinsics.areEqual((Object)v.getDomainFact(), (Object)ZEROFact.INSTANCE)) {
                this.addEdge(v, lastVertex);
                this.sources.add(v);
                return;
            }
            Set set = IfdsResult.this.getPathEdgesPreds().get(e);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            for (PathEdgePredecessor pred : set) {
                PredecessorKind predecessorKind = pred.getKind();
                if (predecessorKind instanceof PredecessorKind.CallToStart) {
                    if (stopAtMethodStart) continue;
                    this.addEdge(pred.getPredEdge().getV(), lastVertex);
                    this.dfs(pred.getPredEdge(), pred.getPredEdge().getV(), false);
                    continue;
                }
                if (predecessorKind instanceof PredecessorKind.Sequent) {
                    if (Intrinsics.areEqual((Object)pred.getPredEdge().getV().getDomainFact(), (Object)v.getDomainFact())) {
                        this.dfs(pred.getPredEdge(), lastVertex, stopAtMethodStart);
                        continue;
                    }
                    this.addEdge(pred.getPredEdge().getV(), lastVertex);
                    this.dfs(pred.getPredEdge(), pred.getPredEdge().getV(), stopAtMethodStart);
                    continue;
                }
                if (predecessorKind instanceof PredecessorKind.ThroughSummary) {
                    IfdsEdge summaryEdge = ((PredecessorKind.ThroughSummary)pred.getKind()).getSummaryEdge();
                    this.addEdge(summaryEdge.getV(), lastVertex);
                    this.addEdge(pred.getPredEdge().getV(), summaryEdge.getU());
                    this.dfs(summaryEdge, summaryEdge.getV(), true);
                    this.dfs(pred.getPredEdge(), pred.getPredEdge().getV(), stopAtMethodStart);
                    continue;
                }
                if (predecessorKind instanceof PredecessorKind.Unknown) {
                    this.addEdge(pred.getPredEdge().getV(), lastVertex);
                    if (Intrinsics.areEqual((Object)pred.getPredEdge().getU(), (Object)pred.getPredEdge().getV())) continue;
                    this.dfs(new IfdsEdge(pred.getPredEdge().getU(), pred.getPredEdge().getU()), pred.getPredEdge().getV(), stopAtMethodStart);
                    continue;
                }
                if (!(predecessorKind instanceof PredecessorKind.NoPredecessor)) continue;
                this.sources.add(v);
                this.addEdge(pred.getPredEdge().getV(), lastVertex);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TraceGraph build() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = IfdsResult.this.getPathEdges();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IfdsEdge it = (IfdsEdge)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getV(), (Object)this.sink)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List initEdges = (List)destination$iv$iv;
            Iterable $this$forEach$iv = initEdges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IfdsEdge it = (IfdsEdge)element$iv;
                boolean bl = false;
                this.dfs(it, it.getV(), false);
            }
            return new TraceGraph(this.sink, this.sources, this.edges);
        }
    }
}

