/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.engine;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jacodb.analysis.engine.SummaryFact;
import org.jacodb.analysis.engine.SummaryStorage;
import org.jacodb.analysis.engine.SummaryStorageImpl;
import org.jacodb.api.JcMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00122\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jacodb/analysis/engine/SummaryStorageImpl;", "T", "Lorg/jacodb/analysis/engine/SummaryFact;", "Lorg/jacodb/analysis/engine/SummaryStorage;", "()V", "knownMethods", "", "Lorg/jacodb/api/JcMethod;", "getKnownMethods", "()Ljava/util/List;", "outFlows", "", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "summaries", "", "getCurrentFacts", "method", "getFacts", "Lkotlinx/coroutines/flow/SharedFlow;", "send", "", "fact", "(Lorg/jacodb/analysis/engine/SummaryFact;)V", "jacodb-analysis"})
public final class SummaryStorageImpl<T extends SummaryFact>
implements SummaryStorage<T> {
    @NotNull
    private final Map<JcMethod, Set<T>> summaries = new ConcurrentHashMap();
    @NotNull
    private final Map<JcMethod, MutableSharedFlow<T>> outFlows = new ConcurrentHashMap();

    @Override
    public void send(@NotNull T fact) {
        Intrinsics.checkNotNullParameter(fact, (String)"fact");
        if (this.summaries.computeIfAbsent(fact.getMethod(), send.1.INSTANCE).add(fact)) {
            MutableSharedFlow<T> mutableSharedFlow = this.outFlows.computeIfAbsent(fact.getMethod(), send.outFlow.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(mutableSharedFlow, (String)"outFlows.computeIfAbsent\u2026replay = Int.MAX_VALUE) }");
            MutableSharedFlow<T> outFlow2 = mutableSharedFlow;
            if (!outFlow2.tryEmit(fact)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Override
    @NotNull
    public SharedFlow<T> getFacts(@NotNull JcMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        MutableSharedFlow<T> mutableSharedFlow = this.outFlows.computeIfAbsent(method, new Function(this, method){
            final /* synthetic */ SummaryStorageImpl<T> this$0;
            final /* synthetic */ JcMethod $method;
            {
                this.this$0 = $receiver;
                this.$method = $method;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MutableSharedFlow<T> apply(@NotNull JcMethod it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MutableSharedFlow mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)Integer.MAX_VALUE, (int)0, null, (int)6, null);
                SummaryStorageImpl<T> summaryStorageImpl = this.this$0;
                JcMethod jcMethod = this.$method;
                MutableSharedFlow flow = mutableSharedFlow;
                boolean bl = false;
                Set set = (Set)SummaryStorageImpl.access$getSummaries$p(summaryStorageImpl).get(jcMethod);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Iterable iterable = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SummaryFact fact = (SummaryFact)element$iv;
                    boolean bl2 = false;
                    if (flow.tryEmit((Object)fact)) continue;
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return mutableSharedFlow;
            }
        });
        Intrinsics.checkNotNullExpressionValue(mutableSharedFlow, (String)"T: SummaryFact> : Summar\u2026        }\n        }\n    }");
        return (SharedFlow)mutableSharedFlow;
    }

    @Override
    @NotNull
    public List<T> getCurrentFacts(@NotNull JcMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return this.getFacts(method).getReplayCache();
    }

    @Override
    @NotNull
    public List<JcMethod> getKnownMethods() {
        return CollectionsKt.toList((Iterable)this.summaries.keySet());
    }

    public static final /* synthetic */ Map access$getSummaries$p(SummaryStorageImpl $this) {
        return $this.summaries;
    }
}

