/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jacodb.api.JcClasspath;
import org.jacodb.api.JcMethod;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.ext.cfg.JcInstructions;
import org.jacodb.impl.features.SyncUsagesExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jacodb/analysis/graph/JcApplicationGraphImpl;", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "classpath", "Lorg/jacodb/api/JcClasspath;", "usages", "Lorg/jacodb/impl/features/SyncUsagesExtension;", "(Lorg/jacodb/api/JcClasspath;Lorg/jacodb/impl/features/SyncUsagesExtension;)V", "getClasspath", "()Lorg/jacodb/api/JcClasspath;", "methods", "", "Lorg/jacodb/api/JcMethod;", "callees", "Lkotlin/sequences/Sequence;", "node", "Lorg/jacodb/api/cfg/JcInst;", "callers", "method", "entryPoint", "exitPoints", "methodOf", "predecessors", "successors", "jacodb-analysis"})
public class JcApplicationGraphImpl
implements JcApplicationGraph {
    @NotNull
    private final JcClasspath classpath;
    @NotNull
    private final SyncUsagesExtension usages;
    @NotNull
    private final Set<JcMethod> methods;

    public JcApplicationGraphImpl(@NotNull JcClasspath classpath, @NotNull SyncUsagesExtension usages) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.classpath = classpath;
        this.usages = usages;
        this.methods = new LinkedHashSet();
    }

    @NotNull
    public JcClasspath getClasspath() {
        return this.classpath;
    }

    @NotNull
    public Sequence<JcInst> predecessors(@NotNull JcInst node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)node.getLocation().getMethod().flowGraph().predecessors(node)), (Sequence)CollectionsKt.asSequence((Iterable)node.getLocation().getMethod().flowGraph().throwers(node)));
    }

    @NotNull
    public Sequence<JcInst> successors(@NotNull JcInst node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)node.getLocation().getMethod().flowGraph().successors(node)), (Sequence)CollectionsKt.asSequence((Iterable)node.getLocation().getMethod().flowGraph().catchers(node)));
    }

    @NotNull
    public Sequence<JcMethod> callees(@NotNull JcInst node) {
        JcCallExpr jcCallExpr;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                jcCallExpr = JcInstructions.getCallExpr((JcInst)node);
                if (jcCallExpr == null || (jcCallExpr = jcCallExpr.getMethod()) == null || (jcCallExpr = jcCallExpr.getMethod()) == null) break block2;
                JcCallExpr it = jcCallExpr;
                boolean bl = false;
                this.methods.add((JcMethod)it);
                Object[] objectArray = new JcMethod[]{it};
                Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
                jcCallExpr = sequence;
                if (sequence != null) break block3;
            }
            jcCallExpr = SequencesKt.emptySequence();
        }
        return jcCallExpr;
    }

    @NotNull
    public Sequence<JcInst> callers(@NotNull JcMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.methods.add(method);
        return SequencesKt.flatMap((Sequence)this.usages.findUsages(method), (Function1)((Function1)new Function1<JcMethod, Sequence<? extends JcInst>>(method){
            final /* synthetic */ JcMethod $method;
            {
                this.$method = $method;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Sequence<JcInst> invoke(@NotNull JcMethod it) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable iterable = it.flowGraph().getInstructions();
                JcMethod jcMethod = this.$method;
                boolean $i$f$filter = false;
                void var5_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    JcInst inst = (JcInst)element$iv$iv;
                    boolean bl = false;
                    JcCallExpr jcCallExpr = JcInstructions.getCallExpr((JcInst)inst);
                    if (!Intrinsics.areEqual((Object)(jcCallExpr != null && (jcCallExpr = jcCallExpr.getMethod()) != null ? jcCallExpr.getMethod() : null), (Object)jcMethod)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public Sequence<JcInst> entryPoint(@NotNull JcMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.methods.add(method);
        return CollectionsKt.asSequence((Iterable)method.flowGraph().getEntries());
    }

    @NotNull
    public Sequence<JcInst> exitPoints(@NotNull JcMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.methods.add(method);
        return CollectionsKt.asSequence((Iterable)method.flowGraph().getExits());
    }

    @NotNull
    public JcMethod methodOf(@NotNull JcInst node) {
        JcMethod jcMethod;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JcMethod it = jcMethod = node.getLocation().getMethod();
        boolean bl = false;
        this.methods.add(it);
        return jcMethod;
    }
}

