/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.impl.custom;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.impl.custom.AbstractFlowAnalysis;
import org.jacodb.analysis.impl.custom.Flow;
import org.jacodb.analysis.impl.custom.FlowAnalysisDirection;
import org.jacodb.analysis.impl.custom.FlowAnalysisImpl;
import org.jacodb.analysis.impl.custom.FlowAnalysisImplKt;
import org.jacodb.analysis.impl.custom.FlowEntry;
import org.jacodb.api.cfg.JcBytecodeGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u000b\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0002J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0017J7\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00122\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ<\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010#2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010#H\u0016J\u001e\u0010%\u001a\u00020\f*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00120&H\u0002J\u0018\u0010'\u001a\u00020\f*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0002R\u0018\u0010\u0007\u001a\u00020\b*\u00028\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lorg/jacodb/analysis/impl/custom/FlowAnalysisImpl;", "NODE", "T", "Lorg/jacodb/analysis/impl/custom/AbstractFlowAnalysis;", "graph", "Lorg/jacodb/api/cfg/JcBytecodeGraph;", "(Lorg/jacodb/api/cfg/JcBytecodeGraph;)V", "canSkip", "", "getCanSkip", "(Ljava/lang/Object;)Z", "flowThrough", "", "instIn", "ins", "instOut", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "entry", "Lorg/jacodb/analysis/impl/custom/FlowEntry;", "getFlow", "Lorg/jacodb/analysis/impl/custom/Flow;", "from", "mergeNode", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jacodb/analysis/impl/custom/Flow;", "o", "e", "(Lorg/jacodb/analysis/impl/custom/FlowEntry;Lorg/jacodb/analysis/impl/custom/FlowEntry;)Ljava/lang/Object;", "s", "(Ljava/lang/Object;)Ljava/lang/Object;", "outs", "runAnalysis", "", "direction", "Lorg/jacodb/analysis/impl/custom/FlowAnalysisDirection;", "inFlow", "", "outFlow", "initFlow", "", "meetFlows", "jacodb-analysis"})
public abstract class FlowAnalysisImpl<NODE, T>
extends AbstractFlowAnalysis<NODE, T> {
    public FlowAnalysisImpl(@NotNull JcBytecodeGraph<NODE> graph) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        super(graph);
    }

    protected abstract void flowThrough(@Nullable T var1, NODE var2, T var3);

    public final T outs(NODE s) {
        Object t = this.getOuts().get(s);
        if (t == null) {
            t = this.newFlow();
        }
        return t;
    }

    @Override
    public T ins(NODE s) {
        Object t = this.getIns().get(s);
        if (t == null) {
            t = this.newFlow();
        }
        return t;
    }

    private final void initFlow(Iterable<? extends FlowEntry<NODE, T>> $this$initFlow) {
        for (FlowEntry flowEntry : $this$initFlow) {
            boolean omit = true;
            Object inFlow = null;
            Object outFlow2 = null;
            if (flowEntry.getIns().length > 1) {
                inFlow = this.newFlow();
                omit = !flowEntry.isStronglyConnected();
            } else {
                boolean bl;
                boolean bl2;
                boolean bl3 = bl2 = flowEntry.getIns().length == 1;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string = "Missing head";
                    throw new AssertionError((Object)string);
                }
                T flow = this.getFlow((FlowEntry)ArraysKt.first((Object[])flowEntry.getIns()), flowEntry);
                boolean bl4 = bl = flow != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl6 = false;
                    String string = "Topological order is broken";
                    throw new AssertionError((Object)string);
                }
                T t = flow;
                Intrinsics.checkNotNull(t);
                inFlow = t;
            }
            outFlow2 = omit && this.getCanSkip(flowEntry.getData()) ? inFlow : (Object)this.newFlow();
            flowEntry.setInFlow(inFlow);
            flowEntry.setOutFlow(outFlow2);
            this.getIns().put(flowEntry.getData(), inFlow);
            this.getOuts().put(flowEntry.getData(), outFlow2);
        }
    }

    protected boolean getCanSkip(NODE $this$canSkip) {
        return false;
    }

    @NotNull
    protected Flow getFlow(NODE from, NODE mergeNode) {
        return Flow.OUT;
    }

    private final T getFlow(FlowEntry<NODE, T> o, FlowEntry<NODE, T> e) {
        return o.getInFlow() == o.getOutFlow() ? o.getOutFlow() : this.getFlow(o.getData(), e.getData()).getFlow(o);
    }

    private final void meetFlows(FlowEntry<NODE, T> $this$meetFlows) {
        boolean bl;
        boolean bl2 = bl = !($this$meetFlows.getIns().length == 0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if ($this$meetFlows.getIns().length > 1) {
            boolean copy = true;
            for (FlowEntry<NODE, T> o : $this$meetFlows.getIns()) {
                T flow = this.getFlow(o, $this$meetFlows);
                T inFlow = $this$meetFlows.getInFlow();
                if (flow == null || inFlow == null) continue;
                if (copy) {
                    copy = false;
                    this.copy(flow, inFlow);
                    continue;
                }
                this.mergeInto($this$meetFlows.getData(), inFlow, flow);
            }
        }
    }

    public int runAnalysis(@NotNull FlowAnalysisDirection direction, @NotNull Map<NODE, ? extends T> inFlow, @NotNull Map<NODE, ? extends T> outFlow2) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(inFlow, (String)"inFlow");
        Intrinsics.checkNotNullParameter(outFlow2, (String)"outFlow");
        List list = FlowAnalysisImplKt.access$newScope(this.getGraph(), direction, this.newEntryFlow(), this.isForward());
        Collection it = list;
        boolean bl = false;
        this.initFlow(it);
        List scope = list;
        Collection it2 = it = new PriorityQueue(runAnalysis.queue.1.INSTANCE);
        boolean bl2 = false;
        ((AbstractQueue)it2).addAll(scope);
        Collection queue2 = it;
        int numComputations = 0;
        while ((FlowEntry)((PriorityQueue)queue2).poll() != null) {
            FlowEntry entry;
            this.meetFlows(entry);
            boolean hasChanged = this.flowThrough(entry);
            if (hasChanged) {
                ((AbstractQueue)queue2).addAll(ArraysKt.toList((Object[])entry.getOuts()));
            }
            ++numComputations;
        }
        return numComputations;
    }

    private final boolean flowThrough(FlowEntry<NODE, T> entry) {
        if (entry.getInFlow() == entry.getOutFlow()) {
            boolean bl;
            boolean bl2 = bl = !entry.isStronglyConnected() || entry.getIns().length == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return true;
        }
        if (entry.isStronglyConnected()) {
            Object out = this.newFlow();
            this.flowThrough(entry.getInFlow(), entry.getData(), out);
            if (Intrinsics.areEqual(out, entry.getOutFlow())) {
                return false;
            }
            T t = entry.getOutFlow();
            if (t != null) {
                T it = t;
                boolean bl = false;
                this.copy(out, it);
            }
            return true;
        }
        T outFlow2 = entry.getOutFlow();
        if (outFlow2 != null) {
            this.flowThrough(entry.getInFlow(), entry.getData(), outFlow2);
        }
        return true;
    }
}

