/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.impl.custom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.impl.custom.BackwardFlowAnalysis;
import org.jacodb.analysis.impl.custom.NullAnalysisMap;
import org.jacodb.analysis.impl.custom.NullableState;
import org.jacodb.api.JcRefType;
import org.jacodb.api.cfg.JcArrayAccess;
import org.jacodb.api.cfg.JcAssignInst;
import org.jacodb.api.cfg.JcBytecodeGraph;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcCastExpr;
import org.jacodb.api.cfg.JcEnterMonitorInst;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcFieldRef;
import org.jacodb.api.cfg.JcGraph;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcInstanceCallExpr;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.cfg.JcValue;
import org.jacodb.api.ext.cfg.JcInstructions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\"\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0017J\u0016\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0017J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006/"}, d2={"Lorg/jacodb/analysis/impl/custom/NullAssumptionAnalysis;", "Lorg/jacodb/analysis/impl/custom/BackwardFlowAnalysis;", "Lorg/jacodb/api/cfg/JcInst;", "Lorg/jacodb/analysis/impl/custom/NullAnalysisMap;", "graph", "Lorg/jacodb/api/cfg/JcGraph;", "(Lorg/jacodb/api/cfg/JcGraph;)V", "ins", "", "getIns", "()Ljava/util/Map;", "outs", "getOuts", "copy", "", "source", "dest", "flowThrough", "instIn", "instOut", "isAlwaysNonNull", "", "v", "Lorg/jacodb/api/cfg/JcValue;", "isAssumedNonNullBefore", "inst", "value", "isAssumedNullBefore", "merge", "in1", "in2", "out", "newEntryFlow", "newFlow", "onArrayAccess", "arrayRef", "Lorg/jacodb/api/cfg/JcArrayAccess;", "onCallExpr", "invokeExpr", "Lorg/jacodb/api/cfg/JcCallExpr;", "onFieldRef", "fieldRef", "Lorg/jacodb/api/cfg/JcFieldRef;", "onRefTypeAssignment", "assignStmt", "Lorg/jacodb/api/cfg/JcAssignInst;", "rhsInfo", "jacodb-analysis"})
public class NullAssumptionAnalysis
extends BackwardFlowAnalysis<JcInst, NullAnalysisMap> {
    @NotNull
    private final Map<JcInst, NullAnalysisMap> ins;
    @NotNull
    private final Map<JcInst, NullAnalysisMap> outs;

    public NullAssumptionAnalysis(@NotNull JcGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        super((JcBytecodeGraph)graph);
        this.ins = new HashMap();
        this.outs = new HashMap();
    }

    @Override
    @NotNull
    public Map<JcInst, NullAnalysisMap> getIns() {
        return this.ins;
    }

    @Override
    @NotNull
    public Map<JcInst, NullAnalysisMap> getOuts() {
        return this.outs;
    }

    @Override
    protected void flowThrough(@Nullable NullAnalysisMap instIn, @NotNull JcInst ins, @NotNull NullAnalysisMap instOut) {
        NullAnalysisMap out;
        NullAnalysisMap nullAnalysisMap;
        NullAnalysisMap it;
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        Intrinsics.checkNotNullParameter((Object)instOut, (String)"instOut");
        NullAnalysisMap nullAnalysisMap2 = instIn;
        if (nullAnalysisMap2 != null) {
            it = nullAnalysisMap2;
            boolean bl = false;
            nullAnalysisMap = new NullAnalysisMap(it);
        } else {
            nullAnalysisMap = out = new NullAnalysisMap();
        }
        if (ins instanceof JcEnterMonitorInst) {
            ((Map)out).put(((JcEnterMonitorInst)ins).getMonitor(), NullableState.NON_NULL);
        }
        JcArrayAccess jcArrayAccess = JcInstructions.getArrayRef((JcInst)ins);
        if (jcArrayAccess != null) {
            it = jcArrayAccess;
            boolean bl = false;
            this.onArrayAccess((JcArrayAccess)it, out);
        }
        JcFieldRef jcFieldRef = JcInstructions.getFieldRef((JcInst)ins);
        if (jcFieldRef != null) {
            it = jcFieldRef;
            boolean bl = false;
            this.onFieldRef((JcFieldRef)it, out);
        }
        JcCallExpr jcCallExpr = JcInstructions.getCallExpr((JcInst)ins);
        if (jcCallExpr != null) {
            it = jcCallExpr;
            boolean bl = false;
            this.onCallExpr((JcCallExpr)it, out);
        }
        for (Map.Entry<JcValue, NullableState> entry : out.entrySet()) {
            JcValue jcValue = entry.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)jcValue, (String)"entry.key");
            if (!this.isAlwaysNonNull(jcValue)) continue;
            entry.setValue(NullableState.NON_NULL);
        }
        if (ins instanceof JcAssignInst && ((JcAssignInst)ins).getLhv().getType() instanceof JcRefType) {
            this.onRefTypeAssignment((JcAssignInst)ins, new NullAnalysisMap(out), out);
        }
        Iterator<JcValue> outIter = out.keySet().iterator();
        while (outIter.hasNext()) {
            JcValue v;
            Intrinsics.checkNotNullExpressionValue((Object)outIter.next(), (String)"outIter.next()");
            if (v instanceof JcLocal) continue;
            outIter.remove();
        }
        this.copy(out, instOut);
    }

    protected boolean isAlwaysNonNull(@NotNull JcValue v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return false;
    }

    private final void onArrayAccess(JcArrayAccess arrayRef, NullAnalysisMap out) {
        ((Map)out).put(arrayRef.getArray(), NullableState.NON_NULL);
    }

    private final void onFieldRef(JcFieldRef fieldRef, NullAnalysisMap out) {
        JcValue instance = fieldRef.getInstance();
        if (instance != null) {
            ((Map)out).put(instance, NullableState.NON_NULL);
        }
    }

    private final void onCallExpr(JcCallExpr invokeExpr, NullAnalysisMap out) {
        if (invokeExpr instanceof JcInstanceCallExpr) {
            ((Map)out).put(((JcInstanceCallExpr)invokeExpr).getInstance(), NullableState.NON_NULL);
        }
    }

    private final void onRefTypeAssignment(JcAssignInst assignStmt, NullAnalysisMap rhsInfo, NullAnalysisMap out) {
        JcValue right;
        JcExpr rhv = assignStmt.getRhv();
        Object object = rhv instanceof JcCastExpr ? ((JcCastExpr)rhv).getOperand() : (right = rhv instanceof JcValue ? (JcValue)rhv : null);
        if (right != null) {
            ((Map)rhsInfo).put(right, NullableState.UNKNOWN);
            ((Map)out).put(assignStmt.getLhv(), rhsInfo.get((Object)right));
        }
    }

    @Override
    public void copy(@Nullable NullAnalysisMap source, @NotNull NullAnalysisMap dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.clear();
        if (source != null) {
            dest.putAll(source);
        }
    }

    @Override
    @NotNull
    public NullAnalysisMap newEntryFlow() {
        return new NullAnalysisMap();
    }

    @Override
    @NotNull
    public NullAnalysisMap newFlow() {
        return new NullAnalysisMap();
    }

    @Override
    public void merge(@NotNull NullAnalysisMap in1, @NotNull NullAnalysisMap in2, @NotNull NullAnalysisMap out) {
        Intrinsics.checkNotNullParameter((Object)in1, (String)"in1");
        Intrinsics.checkNotNullParameter((Object)in2, (String)"in2");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        HashSet values = new HashSet();
        values.addAll(in1.keySet());
        values.addAll(in2.keySet());
        out.clear();
        for (JcValue v : values) {
            HashSet<Object> leftAndRight = new HashSet<Object>();
            leftAndRight.add(in1.get((Object)v));
            leftAndRight.add(in2.get((Object)v));
            NullableState result = leftAndRight.contains((Object)NullableState.UNKNOWN) ? NullableState.UNKNOWN : (leftAndRight.contains((Object)NullableState.NON_NULL) ? (leftAndRight.contains((Object)NullableState.NULL) ? NullableState.UNKNOWN : NullableState.NON_NULL) : (leftAndRight.contains((Object)NullableState.NULL) ? NullableState.NULL : NullableState.UNKNOWN));
            Map map2 = out;
            Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
            map2.put(v, result);
        }
    }

    public final boolean isAssumedNullBefore(@NotNull JcInst inst, @NotNull JcValue value) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((NullAnalysisMap)this.ins(inst)).get((Object)value) == NullableState.NULL;
    }

    public final boolean isAssumedNonNullBefore(@NotNull JcInst inst, @NotNull JcValue value) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return ((NullAnalysisMap)this.ins(inst)).get((Object)value) == NullableState.NON_NULL;
    }
}

