/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.library.analyzers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.AbstractAnalyzer;
import org.jacodb.analysis.engine.AnalysisDependentEvent;
import org.jacodb.analysis.engine.CrossUnitCallFact;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.EdgeForOtherRunnerQuery;
import org.jacodb.analysis.engine.FlowFunctionsSpace;
import org.jacodb.analysis.engine.IfdsEdge;
import org.jacodb.analysis.engine.IfdsVertex;
import org.jacodb.analysis.engine.NewSummaryFact;
import org.jacodb.analysis.engine.VulnerabilityLocation;
import org.jacodb.analysis.library.analyzers.NpeForwardFunctions;
import org.jacodb.analysis.library.analyzers.NpeTaintNode;
import org.jacodb.analysis.paths.UtilKt;
import org.jacodb.analysis.sarif.SarifMessage;
import org.jacodb.analysis.sarif.VulnerabilityDescription;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jacodb.api.cfg.JcInst;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jacodb/analysis/library/analyzers/NpeAnalyzer;", "Lorg/jacodb/analysis/engine/AbstractAnalyzer;", "graph", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "maxPathLength", "", "(Lorg/jacodb/api/analysis/JcApplicationGraph;I)V", "flowFunctions", "Lorg/jacodb/analysis/engine/FlowFunctionsSpace;", "getFlowFunctions", "()Lorg/jacodb/analysis/engine/FlowFunctionsSpace;", "isMainAnalyzer", "", "()Z", "handleNewCrossUnitCall", "", "Lorg/jacodb/analysis/engine/AnalysisDependentEvent;", "fact", "Lorg/jacodb/analysis/engine/CrossUnitCallFact;", "handleNewEdge", "edge", "Lorg/jacodb/analysis/engine/IfdsEdge;", "Companion", "jacodb-analysis"})
public final class NpeAnalyzer
extends AbstractAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlowFunctionsSpace flowFunctions;
    @NotNull
    public static final String ruleId = "npe-deref";

    public NpeAnalyzer(@NotNull JcApplicationGraph graph, int maxPathLength) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        super(graph);
        this.flowFunctions = new NpeForwardFunctions(graph.getClasspath(), maxPathLength);
    }

    @Override
    @NotNull
    public FlowFunctionsSpace getFlowFunctions() {
        return this.flowFunctions;
    }

    @Override
    public boolean isMainAnalyzer() {
        return true;
    }

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleNewEdge(@NotNull IfdsEdge edge) {
        List list;
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        List $this$handleNewEdge_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        IfdsVertex ifdsVertex = edge.getV();
        JcInst inst = ifdsVertex.component1();
        DomainFact fact0 = ifdsVertex.component2();
        if (fact0 instanceof NpeTaintNode && ((NpeTaintNode)fact0).getActivation() == null && UtilKt.isDereferencedAt(((NpeTaintNode)fact0).getVariable(), inst)) {
            String message = "Dereference of possibly-null " + ((NpeTaintNode)fact0).getVariable();
            VulnerabilityDescription desc = new VulnerabilityDescription(new SarifMessage(message), ruleId, null, 4, null);
            $this$handleNewEdge_u24lambda_u240.add(new NewSummaryFact(new VulnerabilityLocation(desc, edge.getV())));
            this.getVerticesWithTraceGraphNeeded().add(edge.getV());
        }
        $this$handleNewEdge_u24lambda_u240.addAll((Collection)super.handleNewEdge(edge));
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleNewCrossUnitCall(@NotNull CrossUnitCallFact fact) {
        List list;
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        List $this$handleNewCrossUnitCall_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$handleNewCrossUnitCall_u24lambda_u241.add(new EdgeForOtherRunnerQuery(new IfdsEdge(fact.getCalleeVertex(), fact.getCalleeVertex())));
        $this$handleNewCrossUnitCall_u24lambda_u241.addAll((Collection)super.handleNewCrossUnitCall(fact));
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jacodb/analysis/library/analyzers/NpeAnalyzer$Companion;", "", "()V", "ruleId", "", "jacodb-analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

