/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.library.analyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.ZEROFact;
import org.jacodb.analysis.library.analyzers.AbstractTaintForwardFunctions;
import org.jacodb.analysis.library.analyzers.NpeAnalyzerKt;
import org.jacodb.analysis.library.analyzers.NpeTaintNode;
import org.jacodb.analysis.library.analyzers.TaintNode;
import org.jacodb.analysis.library.analyzers.UtilKt;
import org.jacodb.analysis.paths.AccessPath;
import org.jacodb.analysis.paths.ElementAccessor;
import org.jacodb.analysis.paths.FieldAccessor;
import org.jacodb.api.JcArrayType;
import org.jacodb.api.JcClassOrInterface;
import org.jacodb.api.JcClasspath;
import org.jacodb.api.JcField;
import org.jacodb.api.JcMethod;
import org.jacodb.api.JcParameter;
import org.jacodb.api.JcType;
import org.jacodb.api.cfg.JcArgument;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcConditionExpr;
import org.jacodb.api.cfg.JcConstant;
import org.jacodb.api.cfg.JcEqExpr;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcGraph;
import org.jacodb.api.cfg.JcGraphs;
import org.jacodb.api.cfg.JcIfInst;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.cfg.JcNeqExpr;
import org.jacodb.api.cfg.JcNewArrayExpr;
import org.jacodb.api.cfg.JcNewExpr;
import org.jacodb.api.cfg.JcNullConstant;
import org.jacodb.api.cfg.JcThis;
import org.jacodb.api.cfg.JcValue;
import org.jacodb.api.ext.JcClasses;
import org.jacodb.api.ext.Nullables;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jacodb/analysis/library/analyzers/NpeForwardFunctions;", "Lorg/jacodb/analysis/library/analyzers/AbstractTaintForwardFunctions;", "cp", "Lorg/jacodb/api/JcClasspath;", "maxPathLength", "", "(Lorg/jacodb/api/JcClasspath;I)V", "pathComparedWithNull", "Lorg/jacodb/analysis/paths/AccessPath;", "Lorg/jacodb/api/cfg/JcIfInst;", "getPathComparedWithNull", "(Lorg/jacodb/api/cfg/JcIfInst;)Lorg/jacodb/analysis/paths/AccessPath;", "obtainPossibleStartFacts", "", "Lorg/jacodb/analysis/engine/DomainFact;", "startStatement", "Lorg/jacodb/api/cfg/JcInst;", "transmitDataFlow", "", "from", "Lorg/jacodb/api/cfg/JcExpr;", "to", "Lorg/jacodb/api/cfg/JcValue;", "atInst", "fact", "dropFact", "", "transmitDataFlowAtNormalInst", "inst", "nextInst", "jacodb-analysis"})
final class NpeForwardFunctions
extends AbstractTaintForwardFunctions {
    private final int maxPathLength;

    public NpeForwardFunctions(@NotNull JcClasspath cp, int maxPathLength) {
        Intrinsics.checkNotNullParameter((Object)cp, (String)"cp");
        super(cp);
        this.maxPathLength = maxPathLength;
    }

    private final AccessPath getPathComparedWithNull(JcIfInst $this$pathComparedWithNull) {
        AccessPath accessPath;
        JcConditionExpr expr = $this$pathComparedWithNull.getCondition();
        if (expr.getRhv() instanceof JcNullConstant) {
            AccessPath accessPath2 = org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)expr.getLhv());
            accessPath = accessPath2 != null ? accessPath2.limit(this.maxPathLength) : null;
        } else if (expr.getLhv() instanceof JcNullConstant) {
            AccessPath accessPath3 = org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)expr.getRhv());
            accessPath = accessPath3 != null ? accessPath3.limit(this.maxPathLength) : null;
        } else {
            accessPath = null;
        }
        return accessPath;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public List<DomainFact> transmitDataFlow(@NotNull JcExpr from, @NotNull JcValue to, @NotNull JcInst atInst, @NotNull DomainFact fact, boolean dropFact) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)atInst, (String)"atInst");
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        List list = dropFact && !Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)fact);
        AccessPath accessPath = org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)to);
        AccessPath accessPath2 = accessPath;
        if (accessPath == null) return list;
        if ((accessPath2 = accessPath2.limit(this.maxPathLength)) == null) {
            return list;
        }
        AccessPath toPath = accessPath2;
        if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
            List list2;
            if (from instanceof JcNullConstant || from instanceof JcCallExpr && NpeAnalyzerKt.access$getTreatAsNullable(((JcCallExpr)from).getMethod().getMethod())) {
                Object[] objectArray = new DomainFact[]{ZEROFact.INSTANCE, new NpeTaintNode(toPath, null, 2, null)};
                list2 = CollectionsKt.listOf((Object[])objectArray);
                return list2;
            }
            if (from instanceof JcNewArrayExpr) {
                JcType jcType = from.getType();
                Intrinsics.checkNotNull((Object)jcType, (String)"null cannot be cast to non-null type org.jacodb.api.JcArrayType");
                if (!Intrinsics.areEqual((Object)((JcArrayType)jcType).getElementType().getNullable(), (Object)false)) {
                    JcType jcType2 = from.getType();
                    Intrinsics.checkNotNull((Object)jcType2, (String)"null cannot be cast to non-null type org.jacodb.api.JcArrayType");
                    int n = ((JcArrayType)jcType2).getDimensions();
                    AccessPath accessPath3 = toPath;
                    AccessPath.Companion companion = AccessPath.Companion;
                    ArrayList<ElementAccessor> arrayList = new ArrayList<ElementAccessor>(n);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        ArrayList<ElementAccessor> arrayList2;
                        if (n2 >= n) {
                            arrayList2 = arrayList;
                            AccessPath arrayElemPath = companion.fromOther(accessPath3, arrayList2);
                            Object[] objectArray = new DomainFact[]{ZEROFact.INSTANCE, new NpeTaintNode(arrayElemPath.limit(this.maxPathLength), null, 2, null)};
                            list2 = CollectionsKt.listOf((Object[])objectArray);
                            return list2;
                        }
                        int n4 = n3 = n2++;
                        arrayList2 = arrayList;
                        boolean bl = false;
                        arrayList2.add(ElementAccessor.INSTANCE);
                    }
                }
            }
            list2 = CollectionsKt.listOf((Object)ZEROFact.INSTANCE);
            return list2;
        }
        if (!(fact instanceof NpeTaintNode)) {
            return CollectionsKt.emptyList();
        }
        AccessPath factPath = ((NpeTaintNode)fact).getVariable();
        if (org.jacodb.analysis.paths.UtilKt.isDereferencedAt(factPath, atInst)) {
            return CollectionsKt.emptyList();
        }
        if (from instanceof JcNewExpr || from instanceof JcNewArrayExpr || from instanceof JcConstant || from instanceof JcCallExpr && !NpeAnalyzerKt.access$getTreatAsNullable(((JcCallExpr)from).getMethod().getMethod())) {
            List list3;
            if (org.jacodb.analysis.paths.UtilKt.startsWith(factPath, toPath)) {
                list3 = CollectionsKt.emptyList();
                return list3;
            }
            list3 = list;
            return list3;
        }
        AccessPath accessPath4 = org.jacodb.analysis.paths.UtilKt.toPathOrNull(from);
        AccessPath accessPath5 = accessPath4;
        if (accessPath4 == null) return list;
        if ((accessPath5 = accessPath5.limit(this.maxPathLength)) == null) {
            return list;
        }
        AccessPath fromPath = accessPath5;
        return UtilKt.normalFactFlow((TaintNode)fact, fromPath, toPath, dropFact, this.maxPathLength);
    }

    @Override
    @NotNull
    public List<DomainFact> transmitDataFlowAtNormalInst(@NotNull JcInst inst, @NotNull JcInst nextInst, @NotNull DomainFact fact) {
        boolean nextInstIsTrueBranch;
        AccessPath accessPath;
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)nextInst, (String)"nextInst");
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        DomainFact domainFact = fact;
        if (domainFact instanceof NpeTaintNode) {
            accessPath = ((NpeTaintNode)fact).getVariable();
        } else if (Intrinsics.areEqual((Object)domainFact, (Object)ZEROFact.INSTANCE)) {
            accessPath = null;
        } else {
            return CollectionsKt.emptyList();
        }
        AccessPath factPath = accessPath;
        if (org.jacodb.analysis.paths.UtilKt.isDereferencedAt(factPath, inst)) {
            return CollectionsKt.emptyList();
        }
        if (!(inst instanceof JcIfInst)) {
            return CollectionsKt.listOf((Object)fact);
        }
        boolean bl = nextInstIsTrueBranch = nextInst.getLocation().getIndex() == ((JcIfInst)inst).getTrueBranch().getIndex();
        if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
            if (this.getPathComparedWithNull((JcIfInst)inst) != null && (((JcIfInst)inst).getCondition() instanceof JcEqExpr && nextInstIsTrueBranch || ((JcIfInst)inst).getCondition() instanceof JcNeqExpr && !nextInstIsTrueBranch)) {
                AccessPath accessPath2 = this.getPathComparedWithNull((JcIfInst)inst);
                Intrinsics.checkNotNull((Object)accessPath2);
                return CollectionsKt.listOf((Object)new NpeTaintNode(accessPath2, null, 2, null));
            }
            return CollectionsKt.listOf((Object)ZEROFact.INSTANCE);
        }
        NpeTaintNode cfr_ignored_0 = (NpeTaintNode)fact;
        JcConditionExpr expr = ((JcIfInst)inst).getCondition();
        if (!Intrinsics.areEqual((Object)this.getPathComparedWithNull((JcIfInst)inst), (Object)((NpeTaintNode)fact).getVariable())) {
            return CollectionsKt.listOf((Object)fact);
        }
        return expr instanceof JcEqExpr && nextInstIsTrueBranch || expr instanceof JcNeqExpr && !nextInstIsTrueBranch ? CollectionsKt.listOf((Object)ZEROFact.INSTANCE) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DomainFact> obtainPossibleStartFacts(@NotNull JcInst startStatement) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        JcArgument it;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)startStatement, (String)"startStatement");
        Object[] objectArray = new DomainFact[]{ZEROFact.INSTANCE};
        List result = CollectionsKt.mutableListOf((Object[])objectArray);
        JcMethod method = startStatement.getLocation().getMethod();
        Collection collection2 = result;
        Iterable iterable = JcGraphs.getLocals((JcGraph)method.flowGraph());
        boolean $i$f$filterIsInstance = false;
        void var7_8 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JcArgument)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (JcArgument)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)Nullables.isNullable((JcParameter)((JcParameter)method.getParameters().get(it.getIndex()))), (Object)false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (JcArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NpeTaintNode(AccessPath.Companion.fromLocal((JcLocal)it), null, 2, null));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection2, (Iterable)$this$map$iv2);
        collection2 = result;
        $this$map$iv2 = JcClasses.getFields((JcClassOrInterface)method.getEnclosingClass());
        $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (JcField)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)Nullables.isNullable((JcField)it), (Object)false) && it.isStatic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (JcField)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NpeTaintNode(AccessPath.Companion.fromStaticField((JcField)it), null, 2, null));
        }
        iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection2, (Iterable)iterable);
        JcThis thisInstance = UtilKt.getThisInstance(method);
        iterable = result;
        Iterable $i$f$map2 = JcClasses.getFields((JcClassOrInterface)method.getEnclosingClass());
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JcField it2 = (JcField)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)Nullables.isNullable((JcField)it2), (Object)false) && !it2.isStatic() && it2.isPublic() && !it2.isFinal())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JcField it2 = (JcField)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new NpeTaintNode(AccessPath.Companion.fromOther(AccessPath.Companion.fromLocal((JcLocal)thisInstance), CollectionsKt.listOf((Object)new FieldAccessor(it2))), null, 2, null));
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        CollectionsKt.addAll((Collection)iterable, (Iterable)iterable2);
        return result;
    }
}

