/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.library.analyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.ZEROFact;
import org.jacodb.analysis.library.analyzers.AbstractTaintBackwardFunctions;
import org.jacodb.analysis.library.analyzers.TaintAnalysisNode;
import org.jacodb.analysis.paths.AccessPath;
import org.jacodb.analysis.paths.Accessor;
import org.jacodb.analysis.paths.UtilKt;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcGraphs;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcInstanceCallExpr;
import org.jacodb.api.cfg.JcValue;
import org.jacodb.api.ext.cfg.JcInstructions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\bH\u0016R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jacodb/analysis/library/analyzers/TaintBackwardFunctions;", "Lorg/jacodb/analysis/library/analyzers/AbstractTaintBackwardFunctions;", "graph", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "generates", "Lkotlin/Function1;", "Lorg/jacodb/api/cfg/JcInst;", "", "Lorg/jacodb/analysis/engine/DomainFact;", "sinks", "Lorg/jacodb/analysis/library/analyzers/TaintAnalysisNode;", "maxPathLength", "", "(Lorg/jacodb/api/analysis/JcApplicationGraph;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;I)V", "getGenerates", "()Lkotlin/jvm/functions/Function1;", "getSinks", "transmitBackDataFlow", "from", "Lorg/jacodb/api/cfg/JcValue;", "to", "Lorg/jacodb/api/cfg/JcExpr;", "atInst", "fact", "dropFact", "", "transmitDataFlowAtNormalInst", "inst", "nextInst", "jacodb-analysis"})
final class TaintBackwardFunctions
extends AbstractTaintBackwardFunctions {
    @NotNull
    private final Function1<JcInst, List<DomainFact>> generates;
    @NotNull
    private final Function1<JcInst, List<TaintAnalysisNode>> sinks;

    public TaintBackwardFunctions(@NotNull JcApplicationGraph graph, @NotNull Function1<? super JcInst, ? extends List<? extends DomainFact>> generates, @NotNull Function1<? super JcInst, ? extends List<TaintAnalysisNode>> sinks, int maxPathLength) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(generates, (String)"generates");
        Intrinsics.checkNotNullParameter(sinks, (String)"sinks");
        super(graph, maxPathLength);
        this.generates = generates;
        this.sinks = sinks;
    }

    @NotNull
    public final Function1<JcInst, List<DomainFact>> getGenerates() {
        return this.generates;
    }

    @NotNull
    public final Function1<JcInst, List<TaintAnalysisNode>> getSinks() {
        return this.sinks;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DomainFact> transmitBackDataFlow(@NotNull JcValue from, @NotNull JcExpr to, @NotNull JcInst atInst, @NotNull DomainFact fact, boolean dropFact) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)atInst, (String)"atInst");
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)ZEROFact.INSTANCE), (Iterable)((Iterable)this.sinks.invoke((Object)atInst)));
        }
        if (!(fact instanceof TaintAnalysisNode)) {
            return CollectionsKt.emptyList();
        }
        AccessPath factPath = ((TaintAnalysisNode)fact).getVariable();
        List list = dropFact || ((List)this.generates.invoke((Object)atInst)).contains(fact) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)fact);
        AccessPath accessPath = UtilKt.toPathOrNull((JcExpr)from);
        if (accessPath == null) {
            return list;
        }
        AccessPath fromPath = accessPath;
        AccessPath toPath = UtilKt.toPathOrNull(to);
        if (toPath != null) {
            List<Accessor> diff = UtilKt.minus(factPath, fromPath);
            if (diff != null) {
                return CollectionsKt.listOf((Object)((TaintAnalysisNode)fact).moveToOtherPath(AccessPath.Companion.fromOther(toPath, diff).limit(this.getMaxPathLength())));
            }
        } else if (UtilKt.startsWith(factPath, fromPath) || to instanceof JcInstanceCallExpr && UtilKt.startsWith(factPath, UtilKt.toPath(((JcInstanceCallExpr)to).getInstance()))) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = JcGraphs.getValues((JcExpr)to);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                AccessPath it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                JcValue it = (JcValue)element$iv$iv;
                boolean bl2 = false;
                if (UtilKt.toPathOrNull((JcExpr)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (AccessPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TaintAnalysisNode((AccessPath)it, null, 2, null));
            }
            return (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DomainFact> transmitDataFlowAtNormalInst(@NotNull JcInst inst, @NotNull JcInst nextInst, @NotNull DomainFact fact) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Intrinsics.checkNotNullParameter((Object)nextInst, (String)"nextInst");
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)fact), (Iterable)((Iterable)this.sinks.invoke((Object)inst)));
        }
        if (!(fact instanceof TaintAnalysisNode)) {
            return CollectionsKt.emptyList();
        }
        JcCallExpr jcCallExpr = JcInstructions.getCallExpr((JcInst)inst);
        JcInstanceCallExpr jcInstanceCallExpr = jcCallExpr instanceof JcInstanceCallExpr ? (JcInstanceCallExpr)jcCallExpr : null;
        if (jcInstanceCallExpr == null) {
            return CollectionsKt.listOf((Object)fact);
        }
        JcInstanceCallExpr callExpr = jcInstanceCallExpr;
        if (UtilKt.startsWith(((TaintAnalysisNode)fact).getVariable(), UtilKt.toPath(callExpr.getInstance()))) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = JcGraphs.getValues((JcInst)inst);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                AccessPath it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                JcValue it = (JcValue)element$iv$iv;
                boolean bl2 = false;
                if (UtilKt.toPathOrNull((JcExpr)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (AccessPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new TaintAnalysisNode((AccessPath)it, null, 2, null));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.listOf((Object)fact);
    }
}

