/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.library.analyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.ZEROFact;
import org.jacodb.analysis.library.analyzers.AbstractTaintForwardFunctions;
import org.jacodb.analysis.library.analyzers.TaintAnalysisNode;
import org.jacodb.analysis.library.analyzers.TaintNode;
import org.jacodb.analysis.library.analyzers.UtilKt;
import org.jacodb.analysis.paths.AccessPath;
import org.jacodb.api.JcMethod;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jacodb.api.cfg.JcArgument;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcGraph;
import org.jacodb.api.cfg.JcGraphs;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcInstanceCallExpr;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.cfg.JcValue;
import org.jacodb.api.ext.cfg.JcInstructions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0016R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jacodb/analysis/library/analyzers/TaintForwardFunctions;", "Lorg/jacodb/analysis/library/analyzers/AbstractTaintForwardFunctions;", "graph", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "maxPathLength", "", "generates", "Lkotlin/Function1;", "Lorg/jacodb/api/cfg/JcInst;", "", "Lorg/jacodb/analysis/engine/DomainFact;", "sanitizes", "Lkotlin/Function2;", "Lorg/jacodb/api/cfg/JcExpr;", "Lorg/jacodb/analysis/library/analyzers/TaintNode;", "", "(Lorg/jacodb/api/analysis/JcApplicationGraph;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "obtainPossibleStartFacts", "", "startStatement", "transmitDataFlow", "from", "to", "Lorg/jacodb/api/cfg/JcValue;", "atInst", "fact", "dropFact", "transmitDataFlowAtNormalInst", "inst", "nextInst", "jacodb-analysis"})
final class TaintForwardFunctions
extends AbstractTaintForwardFunctions {
    private final int maxPathLength;
    @NotNull
    private final Function1<JcInst, List<DomainFact>> generates;
    @NotNull
    private final Function2<JcExpr, TaintNode, Boolean> sanitizes;

    public TaintForwardFunctions(@NotNull JcApplicationGraph graph, int maxPathLength, @NotNull Function1<? super JcInst, ? extends List<? extends DomainFact>> generates, @NotNull Function2<? super JcExpr, ? super TaintNode, Boolean> sanitizes) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(generates, (String)"generates");
        Intrinsics.checkNotNullParameter(sanitizes, (String)"sanitizes");
        super(graph.getClasspath());
        this.maxPathLength = maxPathLength;
        this.generates = generates;
        this.sanitizes = sanitizes;
    }

    @Override
    @NotNull
    public List<DomainFact> transmitDataFlow(@NotNull JcExpr from, @NotNull JcValue to, @NotNull JcInst atInst, @NotNull DomainFact fact, boolean dropFact) {
        boolean bl;
        List newPossibleTaint;
        AccessPath toPath;
        List<DomainFact> list;
        block10: {
            JcInstanceCallExpr jcInstanceCallExpr;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Intrinsics.checkNotNullParameter((Object)atInst, (String)"atInst");
            Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
            if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
                return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)ZEROFact.INSTANCE), (Iterable)((Iterable)this.generates.invoke((Object)atInst)));
            }
            if (!(fact instanceof TaintNode)) {
                return CollectionsKt.emptyList();
            }
            List<DomainFact> list2 = dropFact || (Boolean)this.sanitizes.invoke((Object)from, (Object)fact) != false && Intrinsics.areEqual((Object)((TaintNode)fact).getVariable(), (jcInstanceCallExpr = from instanceof JcInstanceCallExpr ? (JcInstanceCallExpr)from : null) != null && (jcInstanceCallExpr = jcInstanceCallExpr.getInstance()) != null ? org.jacodb.analysis.paths.UtilKt.toPath((JcValue)jcInstanceCallExpr) : null) ? CollectionsKt.emptyList() : (list = CollectionsKt.listOf((Object)fact));
            AccessPath accessPath = org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)to);
            if (accessPath == null || (accessPath = accessPath.limit(this.maxPathLength)) == null) {
                return list;
            }
            toPath = accessPath;
            newPossibleTaint = (Boolean)this.sanitizes.invoke((Object)from, (Object)fact) != false ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)((TaintNode)fact).moveToOtherPath(toPath));
            AccessPath fromPath = org.jacodb.analysis.paths.UtilKt.toPathOrNull(from);
            if (fromPath != null) {
                return (Boolean)this.sanitizes.invoke((Object)from, (Object)fact) != false ? list : (org.jacodb.analysis.paths.UtilKt.startsWith(fromPath, ((TaintNode)fact).getVariable()) ? CollectionsKt.plus((Collection)list, (Iterable)newPossibleTaint) : UtilKt.normalFactFlow((TaintNode)fact, fromPath, toPath, dropFact, this.maxPathLength));
            }
            Iterable $this$any$iv = JcGraphs.getValues((JcExpr)from);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JcValue it = (JcValue)element$iv;
                    boolean bl2 = false;
                    if (!(org.jacodb.analysis.paths.UtilKt.startsWith(org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)it), ((TaintNode)fact).getVariable()) || org.jacodb.analysis.paths.UtilKt.startsWith(((TaintNode)fact).getVariable(), org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)it)))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            AccessPath instancePath;
            JcValue instanceOrNull;
            JcInstanceCallExpr jcInstanceCallExpr = from instanceof JcInstanceCallExpr ? (JcInstanceCallExpr)from : null;
            Object object = instanceOrNull = jcInstanceCallExpr != null ? jcInstanceCallExpr.getInstance() : null;
            if (instanceOrNull != null && !((Boolean)this.sanitizes.invoke((Object)from, (Object)fact)).booleanValue() && (instancePath = org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)instanceOrNull)) != null) {
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)list, (Iterable)newPossibleTaint), (Object)((TaintNode)fact).moveToOtherPath(instancePath));
            }
            return CollectionsKt.plus((Collection)list, (Iterable)newPossibleTaint);
        }
        if (org.jacodb.analysis.paths.UtilKt.startsWith(((TaintNode)fact).getVariable(), toPath)) {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<DomainFact> transmitDataFlowAtNormalInst(@NotNull JcInst inst, @NotNull JcInst nextInst, @NotNull DomainFact fact) {
        boolean factIsPassed;
        JcInstanceCallExpr instance;
        JcCallExpr callExpr;
        block8: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
            Intrinsics.checkNotNullParameter((Object)nextInst, (String)"nextInst");
            Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
            if (Intrinsics.areEqual((Object)fact, (Object)ZEROFact.INSTANCE)) {
                return CollectionsKt.plus((Collection)((Collection)this.generates.invoke((Object)inst)), (Iterable)CollectionsKt.listOf((Object)ZEROFact.INSTANCE));
            }
            if (!(fact instanceof TaintNode)) {
                return CollectionsKt.emptyList();
            }
            JcCallExpr jcCallExpr = JcInstructions.getCallExpr((JcInst)inst);
            if (jcCallExpr == null) {
                return CollectionsKt.listOf((Object)fact);
            }
            callExpr = jcCallExpr;
            JcInstanceCallExpr jcInstanceCallExpr = callExpr instanceof JcInstanceCallExpr ? (JcInstanceCallExpr)callExpr : null;
            if (jcInstanceCallExpr == null || (jcInstanceCallExpr = jcInstanceCallExpr.getInstance()) == null) {
                return CollectionsKt.listOf((Object)fact);
            }
            instance = jcInstanceCallExpr;
            Iterable $this$any$iv = JcGraphs.getValues((JcExpr)((JcExpr)callExpr));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JcValue it = (JcValue)element$iv;
                    boolean bl2 = false;
                    if (!(org.jacodb.analysis.paths.UtilKt.startsWith(org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)it), ((TaintNode)fact).getVariable()) || org.jacodb.analysis.paths.UtilKt.startsWith(((TaintNode)fact).getVariable(), org.jacodb.analysis.paths.UtilKt.toPathOrNull((JcExpr)it)))) continue;
                    bl = true;
                    break block8;
                }
                bl = factIsPassed = false;
            }
        }
        if (Intrinsics.areEqual((Object)org.jacodb.analysis.paths.UtilKt.toPath((JcValue)instance), (Object)((TaintNode)fact).getVariable()) && ((Boolean)this.sanitizes.invoke((Object)callExpr, (Object)fact)).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        return factIsPassed && (Boolean)this.sanitizes.invoke((Object)callExpr, (Object)fact) == false ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)fact), (Object)((TaintNode)fact).moveToOtherPath(org.jacodb.analysis.paths.UtilKt.toPath((JcValue)instance))) : CollectionsKt.listOf((Object)fact);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DomainFact> obtainPossibleStartFacts(@NotNull JcInst startStatement) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)startStatement, (String)"startStatement");
        JcMethod method = startStatement.getLocation().getMethod();
        Iterable iterable = JcGraphs.getLocals((JcGraph)method.flowGraph());
        Collection collection = CollectionsKt.listOf((Object)ZEROFact.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        void var5_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JcArgument)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JcArgument jcArgument = (JcArgument)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new TaintAnalysisNode(AccessPath.Companion.fromLocal((JcLocal)it), null, 2, null));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }
}

