/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.library.analyzers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.engine.AbstractAnalyzer;
import org.jacodb.analysis.engine.AnalysisDependentEvent;
import org.jacodb.analysis.engine.CrossUnitCallFact;
import org.jacodb.analysis.engine.DomainFact;
import org.jacodb.analysis.engine.FlowFunctionsSpace;
import org.jacodb.analysis.engine.IfdsResult;
import org.jacodb.analysis.engine.IfdsVertex;
import org.jacodb.analysis.engine.NewSummaryFact;
import org.jacodb.analysis.engine.VulnerabilityLocation;
import org.jacodb.analysis.engine.ZEROFact;
import org.jacodb.analysis.library.analyzers.UnusedVariableForwardFunctions;
import org.jacodb.analysis.library.analyzers.UnusedVariableNode;
import org.jacodb.analysis.paths.AccessPath;
import org.jacodb.analysis.paths.UtilKt;
import org.jacodb.analysis.sarif.SarifMessage;
import org.jacodb.analysis.sarif.VulnerabilityDescription;
import org.jacodb.api.analysis.JcApplicationGraph;
import org.jacodb.api.cfg.JcArrayAccess;
import org.jacodb.api.cfg.JcAssignInst;
import org.jacodb.api.cfg.JcBranchingInst;
import org.jacodb.api.cfg.JcCallExpr;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcGraphs;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.cfg.JcSpecialCallExpr;
import org.jacodb.api.cfg.JcTerminatingInst;
import org.jacodb.api.cfg.JcValue;
import org.jacodb.api.ext.cfg.JcInstructions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u0016\u001a\u00020\f*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jacodb/analysis/library/analyzers/UnusedVariableAnalyzer;", "Lorg/jacodb/analysis/engine/AbstractAnalyzer;", "graph", "Lorg/jacodb/api/analysis/JcApplicationGraph;", "(Lorg/jacodb/api/analysis/JcApplicationGraph;)V", "flowFunctions", "Lorg/jacodb/analysis/engine/FlowFunctionsSpace;", "getFlowFunctions", "()Lorg/jacodb/analysis/engine/FlowFunctionsSpace;", "getGraph", "()Lorg/jacodb/api/analysis/JcApplicationGraph;", "isMainAnalyzer", "", "()Z", "handleIfdsResult", "", "Lorg/jacodb/analysis/engine/AnalysisDependentEvent;", "ifdsResult", "Lorg/jacodb/analysis/engine/IfdsResult;", "handleNewCrossUnitCall", "fact", "Lorg/jacodb/analysis/engine/CrossUnitCallFact;", "isUsedAt", "Lorg/jacodb/analysis/paths/AccessPath;", "expr", "Lorg/jacodb/api/cfg/JcExpr;", "inst", "Lorg/jacodb/api/cfg/JcInst;", "Companion", "jacodb-analysis"})
public final class UnusedVariableAnalyzer
extends AbstractAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JcApplicationGraph graph;
    @NotNull
    private final FlowFunctionsSpace flowFunctions;
    @NotNull
    public static final String ruleId = "unused-variable";
    @NotNull
    private static final SarifMessage vulnerabilityMessage = new SarifMessage("Assigned value is unused");
    @NotNull
    private static final VulnerabilityDescription vulnerabilityDescription = new VulnerabilityDescription(vulnerabilityMessage, "unused-variable", null, 4, null);

    public UnusedVariableAnalyzer(@NotNull JcApplicationGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        super(graph);
        this.graph = graph;
        this.flowFunctions = new UnusedVariableForwardFunctions(this.graph.getClasspath());
    }

    @NotNull
    public final JcApplicationGraph getGraph() {
        return this.graph;
    }

    @Override
    @NotNull
    public FlowFunctionsSpace getFlowFunctions() {
        return this.flowFunctions;
    }

    @Override
    public boolean isMainAnalyzer() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUsedAt(AccessPath $this$isUsedAt, JcExpr expr) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = JcGraphs.getValues((JcExpr)expr);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JcValue jcValue = (JcValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.toPathOrNull((JcExpr)it));
        }
        return ((List)destination$iv$iv).contains($this$isUsedAt);
    }

    private final boolean isUsedAt(AccessPath $this$isUsedAt, JcInst inst) {
        JcCallExpr callExpr = JcInstructions.getCallExpr((JcInst)inst);
        if (callExpr != null) {
            if (callExpr.getMethod().getMethod().isConstructor() && this.isUsedAt($this$isUsedAt, (JcExpr)((JcSpecialCallExpr)callExpr).getInstance())) {
                return false;
            }
            return this.isUsedAt($this$isUsedAt, (JcExpr)callExpr);
        }
        if (inst instanceof JcAssignInst) {
            if (((JcAssignInst)inst).getLhv() instanceof JcArrayAccess) {
                JcValue jcValue = ((JcAssignInst)inst).getLhv();
                Intrinsics.checkNotNull((Object)jcValue, (String)"null cannot be cast to non-null type org.jacodb.api.cfg.JcArrayAccess");
                if (this.isUsedAt($this$isUsedAt, (JcExpr)((JcArrayAccess)jcValue))) {
                    return true;
                }
            }
            return this.isUsedAt($this$isUsedAt, ((JcAssignInst)inst).getRhv()) && (!(((JcAssignInst)inst).getLhv() instanceof JcLocal) || !(((JcAssignInst)inst).getRhv() instanceof JcLocal));
        }
        if (inst instanceof JcTerminatingInst || inst instanceof JcBranchingInst) {
            boolean bl;
            block9: {
                Iterable $this$any$iv = inst.getOperands();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JcExpr it = (JcExpr)element$iv;
                        boolean bl2 = false;
                        if (!this.isUsedAt($this$isUsedAt, it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleNewCrossUnitCall(@NotNull CrossUnitCallFact fact) {
        Intrinsics.checkNotNullParameter((Object)fact, (String)"fact");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnalysisDependentEvent> handleIfdsResult(@NotNull IfdsResult ifdsResult2) {
        void $this$mapTo$iv$iv;
        JcInst facts;
        List list;
        Intrinsics.checkNotNullParameter((Object)ifdsResult2, (String)"ifdsResult");
        List $this$handleIfdsResult_u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Map used = new LinkedHashMap();
        Map<JcInst, Set<DomainFact>> $this$forEach$iv = ifdsResult2.getResultFacts();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<JcInst, Set<DomainFact>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            Map.Entry<JcInst, Set<DomainFact>> entry;
            Map.Entry<JcInst, Set<DomainFact>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            JcInst inst = entry2.getKey();
            facts = entry2.getValue();
            Iterable $this$filterIsInstance$iv = (Iterable)facts;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UnusedVariableNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UnusedVariableNode fact = (UnusedVariableNode)element$iv2;
                boolean bl3 = false;
                if (!used.containsKey(fact.getInitStatement())) {
                    used.put(fact.getInitStatement(), false);
                }
                if (!this.isUsedAt(fact.getVariable(), inst)) continue;
                used.put(fact.getInitStatement(), true);
            }
        }
        Map $this$filterValues$iv = used;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            boolean it = (Boolean)entry.getValue();
            boolean bl4 = false;
            if (!(!it)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            facts = (JcInst)item$iv$iv;
            Collection collection2 = collection;
            boolean bl5 = false;
            collection2.add($this$handleIfdsResult_u24lambda_u246.add(new NewSummaryFact(new VulnerabilityLocation(vulnerabilityDescription, new IfdsVertex((JcInst)it, ZEROFact.INSTANCE)))));
        }
        List cfr_ignored_0 = (List)collection;
        return CollectionsKt.build((List)list);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jacodb/analysis/library/analyzers/UnusedVariableAnalyzer$Companion;", "", "()V", "ruleId", "", "vulnerabilityDescription", "Lorg/jacodb/analysis/sarif/VulnerabilityDescription;", "getVulnerabilityDescription", "()Lorg/jacodb/analysis/sarif/VulnerabilityDescription;", "vulnerabilityMessage", "Lorg/jacodb/analysis/sarif/SarifMessage;", "jacodb-analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VulnerabilityDescription getVulnerabilityDescription() {
            return vulnerabilityDescription;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

