/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.analysis.paths;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.analysis.paths.AccessPath;
import org.jacodb.analysis.paths.Accessor;
import org.jacodb.analysis.paths.ElementAccessor;
import org.jacodb.analysis.paths.FieldAccessor;
import org.jacodb.api.cfg.JcArrayAccess;
import org.jacodb.api.cfg.JcCastExpr;
import org.jacodb.api.cfg.JcExpr;
import org.jacodb.api.cfg.JcFieldRef;
import org.jacodb.api.cfg.JcGraphs;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcInstanceCallExpr;
import org.jacodb.api.cfg.JcLengthExpr;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.cfg.JcValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b*\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\u000b\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\rH\u0000\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0002*\u00020\u0004H\u0000\u00a8\u0006\u000f"}, d2={"isDereferencedAt", "", "Lorg/jacodb/analysis/paths/AccessPath;", "expr", "Lorg/jacodb/api/cfg/JcExpr;", "inst", "Lorg/jacodb/api/cfg/JcInst;", "minus", "", "Lorg/jacodb/analysis/paths/Accessor;", "other", "startsWith", "toPath", "Lorg/jacodb/api/cfg/JcValue;", "toPathOrNull", "jacodb-analysis"})
public final class UtilKt {
    @Nullable
    public static final AccessPath toPathOrNull(@NotNull JcExpr $this$toPathOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$toPathOrNull, (String)"<this>");
        if ($this$toPathOrNull instanceof JcCastExpr) {
            return UtilKt.toPathOrNull((JcExpr)((JcCastExpr)$this$toPathOrNull).getOperand());
        }
        if ($this$toPathOrNull instanceof JcLocal) {
            return AccessPath.Companion.fromLocal((JcLocal)$this$toPathOrNull);
        }
        if ($this$toPathOrNull instanceof JcArrayAccess) {
            AccessPath accessPath;
            AccessPath accessPath2 = UtilKt.toPathOrNull((JcExpr)((JcArrayAccess)$this$toPathOrNull).getArray());
            if (accessPath2 != null) {
                AccessPath it = accessPath2;
                boolean bl = false;
                accessPath = AccessPath.Companion.fromOther(it, CollectionsKt.listOf((Object)ElementAccessor.INSTANCE));
            } else {
                accessPath = null;
            }
            return accessPath;
        }
        if ($this$toPathOrNull instanceof JcFieldRef) {
            AccessPath accessPath;
            JcValue instance = ((JcFieldRef)$this$toPathOrNull).getInstance();
            if (instance == null) {
                accessPath = AccessPath.Companion.fromStaticField(((JcFieldRef)$this$toPathOrNull).getField().getField());
            } else {
                AccessPath accessPath3 = UtilKt.toPathOrNull((JcExpr)instance);
                if (accessPath3 != null) {
                    AccessPath it = accessPath3;
                    boolean bl = false;
                    accessPath = AccessPath.Companion.fromOther(it, CollectionsKt.listOf((Object)new FieldAccessor(((JcFieldRef)$this$toPathOrNull).getField().getField())));
                } else {
                    accessPath = null;
                }
            }
            return accessPath;
        }
        return null;
    }

    @NotNull
    public static final AccessPath toPath(@NotNull JcValue $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        AccessPath accessPath = UtilKt.toPathOrNull((JcExpr)$this$toPath);
        if (accessPath == null) {
            throw new IllegalStateException(("Unable to build access path for value " + $this$toPath).toString());
        }
        return accessPath;
    }

    @Nullable
    public static final List<Accessor> minus(@Nullable AccessPath $this$minus, @NotNull AccessPath other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$minus == null) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)$this$minus.getValue(), (Object)other.getValue())) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)$this$minus.getAccesses(), (int)other.getAccesses().size()), other.getAccesses())) {
            return null;
        }
        return CollectionsKt.drop((Iterable)$this$minus.getAccesses(), (int)other.getAccesses().size());
    }

    public static final boolean startsWith(@Nullable AccessPath $this$startsWith, @Nullable AccessPath other) {
        if ($this$startsWith == null || other == null) {
            return false;
        }
        return UtilKt.minus($this$startsWith, other) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isDereferencedAt(@Nullable AccessPath $this$isDereferencedAt, @NotNull JcExpr expr) {
        boolean bl;
        block9: {
            void $this$mapNotNullTo$iv$iv;
            Object it;
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            if ($this$isDereferencedAt == null) {
                return false;
            }
            JcInstanceCallExpr jcInstanceCallExpr = expr instanceof JcInstanceCallExpr ? (JcInstanceCallExpr)expr : null;
            if (jcInstanceCallExpr != null) {
                it = jcInstanceCallExpr;
                boolean bl2 = false;
                AccessPath instancePath = UtilKt.toPathOrNull((JcExpr)it.getInstance());
                if (UtilKt.startsWith(instancePath, $this$isDereferencedAt)) {
                    return true;
                }
            }
            JcLengthExpr jcLengthExpr = expr instanceof JcLengthExpr ? (JcLengthExpr)expr : null;
            if (jcLengthExpr != null) {
                it = jcLengthExpr;
                boolean bl3 = false;
                AccessPath arrayPath = UtilKt.toPathOrNull((JcExpr)it.getArray());
                if (UtilKt.startsWith(arrayPath, $this$isDereferencedAt)) {
                    return true;
                }
            }
            Iterable $this$mapNotNull$iv = JcGraphs.getValues((JcExpr)expr);
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AccessPath it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                JcValue it2 = (JcValue)element$iv$iv;
                boolean bl5 = false;
                if (UtilKt.toPathOrNull((JcExpr)it2) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AccessPath it3 = (AccessPath)element$iv;
                    boolean bl7 = false;
                    List<Accessor> list = UtilKt.minus(it3, $this$isDereferencedAt);
                    boolean bl8 = list != null ? !((Collection)list).isEmpty() : false;
                    if (!bl8) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isDereferencedAt(@Nullable AccessPath $this$isDereferencedAt, @NotNull JcInst inst) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
            if ($this$isDereferencedAt == null) {
                return false;
            }
            Iterable $this$any$iv = inst.getOperands();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JcExpr it = (JcExpr)element$iv;
                    boolean bl2 = false;
                    if (!UtilKt.isDereferencedAt($this$isDereferencedAt, it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

