/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.api.analysis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.api.JcClasspath;
import org.jacodb.api.JcField;
import org.jacodb.api.JcType;
import org.jacodb.api.analysis.FullObjectsSet;
import org.jacodb.api.analysis.JcPointsToAnalysis;
import org.jacodb.api.analysis.JcPointsToSet;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcLocal;
import org.jacodb.api.ext.JcCommons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jacodb/api/analysis/PrimitivePointsAnalysis;", "Lorg/jacodb/api/analysis/JcPointsToAnalysis;", "Lorg/jacodb/api/cfg/JcInst;", "classpath", "Lorg/jacodb/api/JcClasspath;", "(Lorg/jacodb/api/JcClasspath;)V", "reachingObjects", "Lorg/jacodb/api/analysis/JcPointsToSet;", "field", "Lorg/jacodb/api/JcField;", "set", "local", "Lorg/jacodb/api/cfg/JcLocal;", "context", "reachingObjectsOfArrayElement", "jacodb-api"})
public final class PrimitivePointsAnalysis
implements JcPointsToAnalysis<JcInst> {
    @NotNull
    private final JcClasspath classpath;

    public PrimitivePointsAnalysis(@NotNull JcClasspath classpath) {
        Intrinsics.checkNotNullParameter((Object)classpath, (String)"classpath");
        this.classpath = classpath;
    }

    @Override
    @NotNull
    public JcPointsToSet reachingObjects(@NotNull JcLocal local, @Nullable JcInst context) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        return new FullObjectsSet(local.getType());
    }

    @Override
    @NotNull
    public JcPointsToSet reachingObjects(@NotNull JcField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        JcType jcType = this.classpath.findTypeOrNull(field.getType().getTypeName());
        if (jcType == null) {
            jcType = JcCommons.getObjectType(this.classpath);
        }
        return new FullObjectsSet(jcType);
    }

    @Override
    @NotNull
    public JcPointsToSet reachingObjects(@NotNull JcPointsToSet set, @NotNull JcField field) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.reachingObjects(field);
    }

    @Override
    @NotNull
    public JcPointsToSet reachingObjects(@NotNull JcLocal local, @NotNull JcField field, @Nullable JcInst context) {
        Intrinsics.checkNotNullParameter((Object)local, (String)"local");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.reachingObjects(field);
    }

    @Override
    @NotNull
    public JcPointsToSet reachingObjectsOfArrayElement(@NotNull JcPointsToSet set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        return new FullObjectsSet(JcCommons.getObjectType(this.classpath));
    }
}

