/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.api.cfg;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jacodb.api.cfg.JcInst;
import org.jacodb.api.cfg.JcInstRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jacodb/api/cfg/JcBasicBlock;", "", "start", "Lorg/jacodb/api/cfg/JcInstRef;", "end", "(Lorg/jacodb/api/cfg/JcInstRef;Lorg/jacodb/api/cfg/JcInstRef;)V", "getEnd", "()Lorg/jacodb/api/cfg/JcInstRef;", "getStart", "component1", "component2", "contains", "", "inst", "Lorg/jacodb/api/cfg/JcInst;", "copy", "equals", "other", "hashCode", "", "toString", "", "jacodb-api"})
public final class JcBasicBlock {
    @NotNull
    private final JcInstRef start;
    @NotNull
    private final JcInstRef end;

    public JcBasicBlock(@NotNull JcInstRef start, @NotNull JcInstRef end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final JcInstRef getStart() {
        return this.start;
    }

    @NotNull
    public final JcInstRef getEnd() {
        return this.end;
    }

    public final boolean contains(@NotNull JcInst inst) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        return inst.getLocation().getIndex() <= this.end.getIndex() && inst.getLocation().getIndex() >= this.start.getIndex();
    }

    public final boolean contains(@NotNull JcInstRef inst) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        return inst.getIndex() <= this.end.getIndex() && inst.getIndex() >= this.start.getIndex();
    }

    @NotNull
    public final JcInstRef component1() {
        return this.start;
    }

    @NotNull
    public final JcInstRef component2() {
        return this.end;
    }

    @NotNull
    public final JcBasicBlock copy(@NotNull JcInstRef start, @NotNull JcInstRef end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new JcBasicBlock(start, end);
    }

    public static /* synthetic */ JcBasicBlock copy$default(JcBasicBlock jcBasicBlock, JcInstRef jcInstRef, JcInstRef jcInstRef2, int n, Object object) {
        if ((n & 1) != 0) {
            jcInstRef = jcBasicBlock.start;
        }
        if ((n & 2) != 0) {
            jcInstRef2 = jcBasicBlock.end;
        }
        return jcBasicBlock.copy(jcInstRef, jcInstRef2);
    }

    @NotNull
    public String toString() {
        return "JcBasicBlock(start=" + this.start + ", end=" + this.end + ')';
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JcBasicBlock)) {
            return false;
        }
        JcBasicBlock jcBasicBlock = (JcBasicBlock)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)jcBasicBlock.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)jcBasicBlock.end);
    }
}

