/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.api.ext;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jacodb.api.ExceptionsKt;
import org.jacodb.api.JcAnnotated;
import org.jacodb.api.JcAnnotation;
import org.jacodb.api.JcClassOrInterface;
import org.jacodb.api.JcClassType;
import org.jacodb.api.JcClasspath;
import org.jacodb.api.JcRefType;
import org.jacodb.api.JcType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u001b"}, d2={"jvmPrimitiveNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getJvmPrimitiveNames", "()Ljava/util/HashSet;", "cloneableClass", "Lorg/jacodb/api/JcClassOrInterface;", "Lorg/jacodb/api/JcClasspath;", "getCloneableClass", "(Lorg/jacodb/api/JcClasspath;)Lorg/jacodb/api/JcClassOrInterface;", "objectClass", "getObjectClass", "objectType", "Lorg/jacodb/api/JcClassType;", "getObjectType", "(Lorg/jacodb/api/JcClasspath;)Lorg/jacodb/api/JcClassType;", "serializableClass", "getSerializableClass", "annotation", "Lorg/jacodb/api/JcAnnotation;", "Lorg/jacodb/api/JcAnnotated;", "className", "hasAnnotation", "", "jcdbName", "jvmName", "jacodb-api"})
@JvmName(name="JcCommons")
public final class JcCommons {
    @NotNull
    private static final HashSet<String> jvmPrimitiveNames;

    @NotNull
    public static final String jvmName(@NotNull String $this$jvmName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$jvmName, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"boolean")) {
            string = "Z";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"byte")) {
            string = "B";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"char")) {
            string = "C";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"short")) {
            string = "S";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"int")) {
            string = "I";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"float")) {
            string = "F";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"long")) {
            string = "J";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"double")) {
            string = "D";
        } else if (Intrinsics.areEqual((Object)$this$jvmName, (Object)"void")) {
            string = "V";
        } else if (StringsKt.endsWith$default((String)$this$jvmName, (String)"[]", (boolean)false, (int)2, null)) {
            String string2 = $this$jvmName.substring(0, $this$jvmName.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String elementName = string2;
            string = '[' + JcCommons.jvmName(elementName);
        } else {
            string = 'L' + StringsKt.replace$default((String)$this$jvmName, (char)'.', (char)'/', (boolean)false, (int)4, null) + ';';
        }
        return string;
    }

    @NotNull
    public static final HashSet<String> getJvmPrimitiveNames() {
        return jvmPrimitiveNames;
    }

    @NotNull
    public static final String jcdbName(@NotNull String $this$jcdbName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$jcdbName, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"Z")) {
            string = "boolean";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"B")) {
            string = "byte";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"C")) {
            string = "char";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"S")) {
            string = "short";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"I")) {
            string = "int";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"F")) {
            string = "float";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"J")) {
            string = "long";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"D")) {
            string = "double";
        } else if (Intrinsics.areEqual((Object)$this$jcdbName, (Object)"V")) {
            string = "void";
        } else if (StringsKt.startsWith$default((String)$this$jcdbName, (String)"[", (boolean)false, (int)2, null)) {
            String string2 = $this$jcdbName.substring(1, $this$jcdbName.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String elementName = string2;
            string = JcCommons.jcdbName(elementName) + "[]";
        } else if (StringsKt.startsWith$default((String)$this$jcdbName, (String)"L", (boolean)false, (int)2, null)) {
            String string3 = $this$jcdbName.substring(1, $this$jcdbName.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = StringsKt.replace$default((String)string3, (char)'/', (char)'.', (boolean)false, (int)4, null);
        } else {
            string = StringsKt.replace$default((String)$this$jcdbName, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }
        return string;
    }

    @NotNull
    public static final JcClassType getObjectType(@NotNull JcClasspath $this$objectType) {
        JcRefType jcRefType;
        Intrinsics.checkNotNullParameter((Object)$this$objectType, (String)"<this>");
        JcClasspath $this$findTypeOrNull$iv = $this$objectType;
        boolean $i$f$findTypeOrNull = false;
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        JcClassOrInterface jcClassOrInterface = $this$findTypeOrNull$iv.findClassOrNull(string);
        if (jcClassOrInterface != null) {
            JcClassOrInterface it$iv = jcClassOrInterface;
            boolean bl = false;
            jcRefType = JcClasspath.typeOf$default($this$findTypeOrNull$iv, it$iv, null, null, 6, null);
        } else {
            jcRefType = null;
        }
        JcType jcType = jcRefType;
        JcClassType jcClassType = jcType instanceof JcClassType ? (JcClassType)jcType : null;
        if (jcClassType == null) {
            boolean $i$f$throwClassNotFound = false;
            String string2 = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
            ExceptionsKt.throwClassNotFound(string2);
            throw new KotlinNothingValueException();
        }
        return jcClassType;
    }

    @NotNull
    public static final JcClassOrInterface getObjectClass(@NotNull JcClasspath $this$objectClass) {
        Intrinsics.checkNotNullParameter((Object)$this$objectClass, (String)"<this>");
        JcClasspath $this$findClass$iv = $this$objectClass;
        boolean $i$f$findClass = false;
        JcClasspath $this$findClassOrNull$iv$iv = $this$findClass$iv;
        boolean $i$f$findClassOrNull = false;
        String string = Object.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        JcClassOrInterface jcClassOrInterface = $this$findClassOrNull$iv$iv.findClassOrNull(string);
        if (jcClassOrInterface == null) {
            boolean $i$f$throwClassNotFound = false;
            String string2 = Object.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
            ExceptionsKt.throwClassNotFound(string2);
            throw new KotlinNothingValueException();
        }
        return jcClassOrInterface;
    }

    @NotNull
    public static final JcClassOrInterface getCloneableClass(@NotNull JcClasspath $this$cloneableClass) {
        Intrinsics.checkNotNullParameter((Object)$this$cloneableClass, (String)"<this>");
        JcClasspath $this$findClass$iv = $this$cloneableClass;
        boolean $i$f$findClass = false;
        JcClasspath $this$findClassOrNull$iv$iv = $this$findClass$iv;
        boolean $i$f$findClassOrNull = false;
        String string = Cloneable.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        JcClassOrInterface jcClassOrInterface = $this$findClassOrNull$iv$iv.findClassOrNull(string);
        if (jcClassOrInterface == null) {
            boolean $i$f$throwClassNotFound = false;
            String string2 = Cloneable.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
            ExceptionsKt.throwClassNotFound(string2);
            throw new KotlinNothingValueException();
        }
        return jcClassOrInterface;
    }

    @NotNull
    public static final JcClassOrInterface getSerializableClass(@NotNull JcClasspath $this$serializableClass) {
        Intrinsics.checkNotNullParameter((Object)$this$serializableClass, (String)"<this>");
        JcClasspath $this$findClass$iv = $this$serializableClass;
        boolean $i$f$findClass = false;
        JcClasspath $this$findClassOrNull$iv$iv = $this$findClass$iv;
        boolean $i$f$findClassOrNull = false;
        String string = Serializable.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        JcClassOrInterface jcClassOrInterface = $this$findClassOrNull$iv$iv.findClassOrNull(string);
        if (jcClassOrInterface == null) {
            boolean $i$f$throwClassNotFound = false;
            String string2 = Serializable.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"T::class.java.name");
            ExceptionsKt.throwClassNotFound(string2);
            throw new KotlinNothingValueException();
        }
        return jcClassOrInterface;
    }

    public static final boolean hasAnnotation(@NotNull JcAnnotated $this$hasAnnotation, @NotNull String className) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Iterable $this$any$iv = $this$hasAnnotation.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JcAnnotation it = (JcAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(className)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final JcAnnotation annotation(@NotNull JcAnnotated $this$annotation, @NotNull String className) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$annotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Iterable $this$firstOrNull$iv = $this$annotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JcAnnotation it = (JcAnnotation)element$iv;
                boolean bl = false;
                if (!it.matches(className)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Object[] objectArray = new String[]{"Z", "B", "C", "S", "I", "F", "J", "D", "V"};
        jvmPrimitiveNames = SetsKt.hashSetOf((Object[])objectArray);
    }
}

