/*
 * Decompiled with CFR 0.152.
 */
package org.jacodb.api.ext;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jacodb.api.JcClassOrInterface;
import org.jacodb.api.JcClasspath;
import org.jacodb.api.JcField;
import org.jacodb.api.JcMethod;
import org.jacodb.api.ext.FieldUsagesResult;
import org.jacodb.api.ext.JcClasses;
import org.jacodb.api.ext.JcMethods;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\"\u0015\u0010\n\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"CONSTRUCTOR", "", "hasBody", "", "Lorg/jacodb/api/JcMethod;", "(Lorg/jacodb/api/JcMethod;)Z", "humanReadableSignature", "getHumanReadableSignature", "(Lorg/jacodb/api/JcMethod;)Ljava/lang/String;", "isStrict", "jcdbSignature", "getJcdbSignature", "jvmSignature", "getJvmSignature", "usedFields", "Lorg/jacodb/api/ext/FieldUsagesResult;", "getUsedFields", "(Lorg/jacodb/api/JcMethod;)Lorg/jacodb/api/ext/FieldUsagesResult;", "usedMethods", "", "getUsedMethods", "(Lorg/jacodb/api/JcMethod;)Ljava/util/List;", "jacodb-api"})
@JvmName(name="JcMethods")
public final class JcMethods {
    @NotNull
    public static final String CONSTRUCTOR = "<init>";

    public static final boolean isStrict(@NotNull JcMethod $this$isStrict) {
        Intrinsics.checkNotNullParameter((Object)$this$isStrict, (String)"<this>");
        return ($this$isStrict.getAccess() & 0x800) != 0;
    }

    @NotNull
    public static final String getJvmSignature(@NotNull JcMethod $this$jvmSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$jvmSignature, (String)"<this>");
        return $this$jvmSignature.getName() + $this$jvmSignature.getDescription();
    }

    @NotNull
    public static final String getJcdbSignature(@NotNull JcMethod $this$jcdbSignature) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$jcdbSignature, (String)"<this>");
        String string2 = string = ";";
        StringBuilder stringBuilder = new StringBuilder().append(CollectionsKt.joinToString$default((Iterable)$this$jcdbSignature.getParameters(), (CharSequence)";", null, null, (int)0, null, (Function1)jcdbSignature.params.1.INSTANCE, (int)30, null));
        boolean bl = false;
        boolean bl2 = !((Collection)$this$jcdbSignature.getParameters()).isEmpty();
        String string3 = bl2 ? string : null;
        if (string3 == null) {
            string3 = "";
        }
        String params2 = stringBuilder.append(string3).toString();
        return $this$jcdbSignature.getName() + '(' + params2 + ')' + $this$jcdbSignature.getReturnType().getTypeName() + ';';
    }

    @NotNull
    public static final String getHumanReadableSignature(@NotNull JcMethod $this$humanReadableSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$humanReadableSignature, (String)"<this>");
        String params2 = CollectionsKt.joinToString$default((Iterable)$this$humanReadableSignature.getParameters(), (CharSequence)",", null, null, (int)0, null, (Function1)humanReadableSignature.params.1.INSTANCE, (int)30, null);
        return $this$humanReadableSignature.getEnclosingClass().getName() + '#' + $this$humanReadableSignature.getName() + '(' + params2 + "):" + $this$humanReadableSignature.getReturnType().getTypeName();
    }

    @JvmName(name="hasBody")
    public static final boolean hasBody(@NotNull JcMethod $this$hasBody) {
        Intrinsics.checkNotNullParameter((Object)$this$hasBody, (String)"<this>");
        return !$this$hasBody.isNative() && !$this$hasBody.isAbstract() && $this$hasBody.asmNode().instructions.getFirst() != null;
    }

    @NotNull
    public static final List<JcMethod> getUsedMethods(@NotNull JcMethod $this$usedMethods) {
        Intrinsics.checkNotNullParameter((Object)$this$usedMethods, (String)"<this>");
        JcClasspath cp = $this$usedMethods.getEnclosingClass().getClasspath();
        MethodNode methodNode = $this$usedMethods.asmNode();
        LinkedHashSet<JcMethod> result = new LinkedHashSet<JcMethod>();
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
        Iterable $this$forEach$iv = (Iterable)insnList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcMethod jcMethod;
            AbstractInsnNode instruction = (AbstractInsnNode)element$iv;
            boolean bl = false;
            if (!(instruction instanceof MethodInsnNode)) continue;
            String owner = Type.getObjectType((String)((MethodInsnNode)instruction).owner).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)owner, (String)"owner");
            JcClassOrInterface clazz = cp.findClassOrNull(owner);
            if (clazz == null) continue;
            String string = ((MethodInsnNode)instruction).name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"instruction.name");
            String string2 = ((MethodInsnNode)instruction).desc;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"instruction.desc");
            if (JcClasses.findMethodOrNull(clazz, string, string2) == null) continue;
            JcMethod it = jcMethod;
            boolean bl2 = false;
            result.add(it);
        }
        return (List)ExtensionsKt.toImmutableList((Iterable)result);
    }

    @NotNull
    public static final FieldUsagesResult getUsedFields(@NotNull JcMethod $this$usedFields) {
        Intrinsics.checkNotNullParameter((Object)$this$usedFields, (String)"<this>");
        JcClasspath cp = $this$usedFields.getEnclosingClass().getClasspath();
        MethodNode methodNode = $this$usedFields.asmNode();
        LinkedHashSet<JcField> reads = new LinkedHashSet<JcField>();
        LinkedHashSet<JcField> writes = new LinkedHashSet<JcField>();
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"methodNode.instructions");
        Iterable $this$forEach$iv = (Iterable)insnList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode instruction = (AbstractInsnNode)element$iv;
            boolean bl = false;
            if (!(instruction instanceof FieldInsnNode)) continue;
            String owner = Type.getObjectType((String)((FieldInsnNode)instruction).owner).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)owner, (String)"owner");
            JcClassOrInterface clazz = cp.findClassOrNull(owner);
            if (clazz == null) continue;
            String string = ((FieldInsnNode)instruction).name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"instruction.name");
            JcField jcClass = JcClasses.findFieldOrNull(clazz, string);
            if (jcClass == null) continue;
            switch (((FieldInsnNode)instruction).getOpcode()) {
                case 180: {
                    reads.add(jcClass);
                    break;
                }
                case 178: {
                    reads.add(jcClass);
                    break;
                }
                case 181: {
                    writes.add(jcClass);
                    break;
                }
                case 179: {
                    writes.add(jcClass);
                }
            }
        }
        return new FieldUsagesResult((List)ExtensionsKt.toImmutableList((Iterable)reads), (List)ExtensionsKt.toImmutableList((Iterable)writes));
    }
}

