/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.BooleanType;
import org.jacorb.idl.CharType;
import org.jacorb.idl.ConstExpr;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.ElementSpec;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IntType;
import org.jacorb.idl.Literal;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.UnionType;
import org.jacorb.idl.parser;

public class Case
extends IdlSymbol {
    public SymbolList case_label_list = null;
    private IdlSymbol[] labels;
    public ElementSpec element_spec = null;
    TypeSpec type_spec = null;

    public Case(int num) {
        super(num);
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.element_spec.setPackage(s);
        Enumeration e = this.case_label_list.v.elements();
        while (e.hasMoreElements()) {
            IdlSymbol sym2 = (IdlSymbol)e.nextElement();
            if (sym2 == null) continue;
            sym2.setPackage(s);
        }
        if (this.type_spec != null) {
            this.type_spec.setPackage(s);
        }
    }

    public void setUnion(UnionType ut) {
        this.element_spec.setUnion(ut);
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        this.element_spec.setEnclosingSymbol(s);
    }

    public void setTypeSpec(TypeSpec s) {
        this.type_spec = s;
    }

    private String enumTypeName() {
        if (this.type_spec.type_spec instanceof ConstrTypeSpec) {
            return ((ConstrTypeSpec)this.type_spec.type_spec).full_name();
        }
        if (this.type_spec.type_spec instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.type_spec.type_spec).resolvedTypeSpec();
            while (ts instanceof ScopedName || ts instanceof AliasTypeSpec) {
                if (ts instanceof ScopedName) {
                    ts = ((ScopedName)ts).resolvedTypeSpec();
                }
                if (!(ts instanceof AliasTypeSpec)) continue;
                ts = ((AliasTypeSpec)ts).originalType();
            }
            if (ts instanceof ConstrTypeSpec) {
                return ((ConstrTypeSpec)ts).c_type_spec.full_name();
            }
        }
        return null;
    }

    @Override
    public void parse() {
        this.element_spec.parse();
        this.labels = new IdlSymbol[this.case_label_list.v.size()];
        int label_idx = 0;
        Enumeration e = this.case_label_list.v.elements();
        while (e.hasMoreElements()) {
            IdlSymbol sym2 = (IdlSymbol)e.nextElement();
            this.labels[label_idx++] = sym2;
            TypeSpec ts = this.type_spec.typeSpec();
            if (sym2 != null && ((ConstExpr)sym2).or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.unary_expr.primary_expr.symbol instanceof Literal) {
                Literal literal = (Literal)((ConstExpr)sym2).or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.unary_expr.primary_expr.symbol;
                if (ts instanceof ScopedName) {
                    while (ts instanceof ScopedName) {
                        ts = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
                        if (!(ts instanceof AliasTypeSpec)) continue;
                        ts = ((AliasTypeSpec)ts).originalType();
                    }
                }
                if (!(ts instanceof BooleanType) && !(ts instanceof IntType) && !(ts instanceof CharType) && (!(ts instanceof BaseType) || !((BaseType)ts).isSwitchType()) || ts instanceof BooleanType && !literal.string.equals("true") && !literal.string.equals("false") || ts instanceof CharType && !literal.string.startsWith("'")) {
                    parser.error("Illegal case label <" + literal.string + "> for switch type " + this.type_spec.typeName(), this.token);
                    return;
                }
                if (ts instanceof IntType) {
                    try {
                        Integer.parseInt(literal.string);
                    }
                    catch (NumberFormatException ne) {
                        parser.error("Illegal case label <" + literal.string + "> for integral switch type " + this.type_spec.typeName(), this.token);
                        return;
                    }
                }
            }
            if (this.enumTypeName() == null) {
                if (sym2 == null) continue;
                sym2.parse();
                continue;
            }
            if (sym2 == null) continue;
            ScopedName sn = (ScopedName)((ConstExpr)sym2).or_expr.xor_expr.and_expr.shift_expr.add_expr.mult_expr.unary_expr.primary_expr.symbol;
            int idx = this.case_label_list.v.indexOf(sym2);
            sym2 = new ScopedName(Case.new_num());
            ((ScopedName)sym2).setId(sn.typeName);
            sym2.setPackage(this.pack_name);
            sym2.parse();
            this.case_label_list.v.setElementAt(sym2, idx);
        }
    }

    IdlSymbol[] getLabels() {
        if (this.labels == null) {
            throw new RuntimeException("Case labels not initialized!");
        }
        return this.labels;
    }

    @Override
    public void print(PrintWriter ps) {
        this.element_spec.print(ps);
    }
}

