/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.Environment;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.Operation;
import org.jacorb.idl.RaisesExpr;
import org.jacorb.idl.TypeSpec;

public class Method
implements Operation {
    public TypeSpec resultType;
    public TypeSpec parameterType;
    private String name;
    private RaisesExpr raisesExpr;
    private boolean pseudo;

    public Method(TypeSpec res, TypeSpec params, String name, RaisesExpr raisesExpr, boolean pseudo) {
        this.resultType = res;
        this.parameterType = params;
        this.name = name;
        this.raisesExpr = raisesExpr;
        this.pseudo = pseudo;
    }

    public boolean isGetter() {
        return this.resultType != null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String opName() {
        if (this.isGetter()) {
            return "_get_" + this.name;
        }
        return "_set_" + this.name;
    }

    @Override
    public String signature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "(");
        if (this.parameterType != null) {
            sb.append(this.parameterType.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void printSignature(PrintWriter ps) {
        this.printSignature(ps, this.pseudo);
    }

    @Override
    public void printSignature(PrintWriter ps, boolean printModifiers) {
        ps.print("\t");
        if (printModifiers) {
            ps.print("public abstract ");
        }
        if (this.isGetter()) {
            ps.print(this.resultType.toString());
            ps.print(" " + this.name + "()");
            this.raisesExpr.print(ps);
            ps.println(";");
        } else {
            ps.print("void " + this.name + "(");
            ps.print(this.parameterType.toString());
            ps.print(" arg)");
            this.raisesExpr.print(ps);
            ps.println(";");
        }
    }

    @Override
    public void printMethod(PrintWriter ps, String classname, boolean is_local, boolean is_abstract) {
        ps.print("\tpublic ");
        if (this.isGetter()) {
            ps.print(this.resultType.toString());
            ps.print(" " + this.name + "()");
            this.raisesExpr.print(ps);
            ps.println();
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            if (!is_local) {
                ps.println("\t\t\tif(! this._is_local())");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
                ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = null;");
                ps.println("\t\t\t\ttry");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\t_os = _request(\"_get_" + this.name + "\",true);");
                ps.println("\t\t\t\t\t_is = _invoke(_os);");
                TypeSpec ts = this.resultType.typeSpec();
                ps.println("\t\t\t\t\treturn " + ts.printReadExpression("_is") + ";");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx )");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\tcontinue;");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\tString _id = _ax.getId();");
                ps.println("\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t_ax.getInputStream().close();");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t}");
                if (!this.raisesExpr.empty()) {
                    String[] exceptIds = this.raisesExpr.getExceptionIds();
                    String[] classNames = this.raisesExpr.getExceptionClassNames();
                    ps.print("\t\t\t\t");
                    for (int i = 0; i < exceptIds.length; ++i) {
                        if (i > 0) {
                            ps.print("\t\t\t\telse ");
                        }
                        ps.println("if( _id.equals(\"" + exceptIds[i] + "\"))");
                        ps.println("\t\t\t\t{");
                        ps.println("\t\t\t\t\tthrow " + classNames[i] + "Helper.read(_ax.getInputStream());");
                        ps.println("\t\t\t\t}");
                    }
                }
                ps.println("\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t\tfinally");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\tif (_os != null)");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\t_os.close();");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tthis._releaseReply(_is);");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t}" + Environment.NL);
                ps.println("\t\t\telse");
                ps.println("\t\t\t{");
            }
            ps.println("\t\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_get_" + this.name + "\", _opsClass);");
            ps.println("\t\t\t\tif( _so == null )");
            ps.println("\t\t\t\t\tcontinue;");
            if (is_abstract) {
                ps.println("\t\t\t\t" + classname + " _localServant = (" + classname + ")_so.servant;");
            } else {
                ps.println("\t\t\t\t" + classname + "Operations _localServant = (" + classname + "Operations)_so.servant;");
            }
            ps.println("\t\t\t\t" + this.resultType + " _result;");
            ps.println("\t\t\t\ttry");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_result = _localServant." + this.name + "();");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).normalCompletion();");
            ps.println("\t\t\t\t\t\treturn _result;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tcatch (RuntimeException re) ");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(re);");
            ps.println("\t\t\t\t\tthrow re;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tcatch (java.lang.Error err) ");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(err);");
            ps.println("\t\t\t\t\tthrow err;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tfinally");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_servant_postinvoke(_so);");
            ps.println("\t\t\t\t}");
            if (!is_local) {
                ps.println("\t\t\t}" + Environment.NL);
            }
            ps.println("\t\t}" + Environment.NL);
            ps.println("\t}" + Environment.NL);
        } else {
            ps.print("void " + this.name + "(" + this.parameterType.toString());
            ps.print(" a)");
            this.raisesExpr.print(ps);
            ps.println();
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            if (!is_local) {
                ps.println("\t\t\tif(! this._is_local())");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\torg.omg.CORBA.portable.InputStream _is = null;");
                ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = null;");
                ps.println("\t\t\t\ttry");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\t_os = _request(\"_set_" + this.name + "\",true);");
                ps.println("\t\t\t\t\t" + this.parameterType.typeSpec().printWriteStatement("a", "_os"));
                ps.println("\t\t\t\t\t_is = _invoke(_os);");
                ps.println("\t\t\t\t\treturn;");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx )");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\tcontinue;");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\tString _id = _ax.getId();");
                ps.println("\t\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\t\t_ax.getInputStream().close();");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t\t}");
                if (!this.raisesExpr.empty()) {
                    String[] exceptIds = this.raisesExpr.getExceptionIds();
                    String[] classNames = this.raisesExpr.getExceptionClassNames();
                    ps.print("\t\t\t\t");
                    for (int i = 0; i < exceptIds.length; ++i) {
                        if (i > 0) {
                            ps.print("\t\t\t\telse ");
                        }
                        ps.println("if( _id.equals(\"" + exceptIds[i] + "\"))");
                        ps.println("\t\t\t\t{");
                        ps.println("\t\t\t\t\tthrow " + classNames[i] + "Helper.read(_ax.getInputStream());");
                        ps.println("\t\t\t\t}");
                    }
                }
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t\tfinally");
                ps.println("\t\t\t\t{");
                ps.println("\t\t\t\t\tif (_os != null)");
                ps.println("\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\ttry");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\t_os.close();");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t\tcatch (java.io.IOException e)");
                ps.println("\t\t\t\t\t\t{");
                ps.println("\t\t\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
                ps.println("\t\t\t\t\t\t}");
                ps.println("\t\t\t\t\t}");
                ps.println("\t\t\t\t\tthis._releaseReply(_is);");
                ps.println("\t\t\t\t}");
                ps.println("\t\t\t}" + Environment.NL);
                ps.println("\t\t\telse");
                ps.println("\t\t\t{");
            }
            ps.println("\t\t\t\torg.omg.CORBA.portable.ServantObject _so = _servant_preinvoke( \"_set_" + this.name + "\", _opsClass);");
            ps.println("\t\t\t\tif( _so == null )");
            ps.println("\t\t\t\t\tcontinue;");
            ps.println("\t\t\t\t" + classname + "Operations _localServant = (" + classname + "Operations)_so.servant;");
            ps.println("\t\t\t\ttry");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_localServant." + this.name + "(a);");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).normalCompletion();");
            ps.println("\t\t\t\t\treturn;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tcatch (RuntimeException re) ");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(re);");
            ps.println("\t\t\t\t\tthrow re;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tcatch (java.lang.Error err) ");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\tif ( _so instanceof org.omg.CORBA.portable.ServantObjectExt) ");
            ps.println("\t\t\t\t\t\t((org.omg.CORBA.portable.ServantObjectExt)_so).exceptionalCompletion(err);");
            ps.println("\t\t\t\t\tthrow err;");
            ps.println("\t\t\t\t}");
            ps.println("\t\t\t\tfinally");
            ps.println("\t\t\t\t{");
            ps.println("\t\t\t\t\t_servant_postinvoke(_so);");
            ps.println("\t\t\t\t}");
            if (!is_local) {
                ps.println("\t\t\t}" + Environment.NL);
            }
            ps.println("\t\t}" + Environment.NL);
            ps.println("\t}" + Environment.NL);
        }
    }

    @Override
    public void print_sendc_Method(PrintWriter ps, String classname) {
        ps.print("\tpublic void sendc_");
        if (this.isGetter()) {
            ps.print("get_" + this.name);
            ps.println("(AMI_" + classname + "Handler ami_handler)");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_get_" + this.name + "\",true);");
            ps.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
            ps.println("\t\t\t\treturn;");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tString _id = _ax.getId();");
            ps.println("\t\t\t\t\ttry");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\t\t\t_ax.getInputStream().close();");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\t\tcatch (java.io.IOException e)");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t}" + Environment.NL);
        } else {
            ps.print("set_" + this.name);
            ps.print("(AMI_" + classname + "Handler ami_handler, ");
            ps.println(this.parameterType.toString() + " attr_" + this.name + ")");
            ps.println("\t{");
            ps.println("\t\twhile(true)");
            ps.println("\t\t{");
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\torg.omg.CORBA.portable.OutputStream _os = _request(\"_set_" + this.name + "\",true);");
            ps.println("\t\t\t\t" + this.parameterType.typeSpec().printWriteStatement("attr_" + this.name, "_os"));
            ps.println("\t\t\t\t((org.jacorb.orb.Delegate)_get_delegate()).invoke(this, _os, ami_handler);");
            ps.println("\t\t\t\treturn;");
            ps.println("\t\t\t}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.RemarshalException _rx ){}");
            ps.println("\t\t\tcatch( org.omg.CORBA.portable.ApplicationException _ax )");
            ps.println("\t\t\t{");
            ps.println("\t\t\t\tString _id = _ax.getId();");
            ps.println("\t\t\t\t\ttry");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\t\t\t_ax.getInputStream().close();");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\t\tcatch (java.io.IOException e)");
            ps.println("\t\t\t\t\t{");
            ps.println("\t\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + e.toString() );");
            ps.println("\t\t\t\t\t}");
            ps.println("\t\t\t\tthrow new RuntimeException(\"Unexpected exception \" + _id );");
            ps.println("\t\t\t}");
            ps.println("\t\t}");
            ps.println("\t}" + Environment.NL);
        }
    }

    @Override
    public void printDelegatedMethod(PrintWriter ps) {
        ps.print("\tpublic ");
        if (this.isGetter()) {
            ps.print(this.resultType.toString());
            ps.print(" " + this.name + "()");
            this.raisesExpr.print(ps);
            ps.println();
            ps.println("\t{");
            ps.println("\t\treturn _delegate." + this.name + "();");
            ps.println("\t}" + Environment.NL);
        } else {
            ps.print("void " + this.name + "(" + this.parameterType.toString());
            ps.print(" a)");
            this.raisesExpr.print(ps);
            ps.println();
            ps.println("\t{");
            ps.println("\t\t_delegate." + this.name + "(a);");
            ps.println("\t}" + Environment.NL);
        }
    }

    @Override
    public void printInvocation(PrintWriter ps) {
        if (!this.raisesExpr.empty()) {
            ps.println("\t\t\ttry");
            ps.println("\t\t\t{");
        }
        ps.println("\t\t\t_out = handler.createReply();");
        ps.print("\t\t\t");
        if (this.isGetter()) {
            ps.println(this.resultType.typeSpec().printWriteStatement(this.name + "()", "_out"));
        } else {
            ps.println(this.name + "(" + this.parameterType.printReadExpression("_input") + ");");
        }
        if (!this.raisesExpr.empty()) {
            ps.println("\t\t\t}");
            String[] excepts = this.raisesExpr.getExceptionNames();
            String[] classNames = this.raisesExpr.getExceptionClassNames();
            for (int i = 0; i < excepts.length; ++i) {
                ps.println("\t\t\tcatch(" + excepts[i] + " _ex" + i + ")");
                ps.println("\t\t\t{");
                ps.println("\t\t\t\t_out = handler.createExceptionReply();");
                ps.println("\t\t\t\t" + classNames[i] + "Helper.write(_out, _ex" + i + ");");
                ps.println("\t\t\t}");
            }
        }
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitMethod(this);
    }
}

