/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.Module;
import org.jacorb.idl.PositionInfo;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.runtime.char_token;
import org.jacorb.idl.runtime.float_token;
import org.jacorb.idl.runtime.int_token;
import org.jacorb.idl.runtime.long_token;
import org.jacorb.idl.runtime.token;
import org.jacorb.idl.str_token;
import org.jacorb.idl.util.IDLLogger;

public class lexer {
    private static IDLLogger logger = parser.getLogger();
    protected static int next_char;
    protected static int next_char2;
    protected static final int EOF_CHAR = -1;
    protected static Hashtable keywords;
    protected static Hashtable keywords_lower_case;
    protected static HashSet java_keywords;
    protected static Hashtable char_symbols;
    protected static Hashtable defines;
    protected static boolean conditionalCompilation;
    private static Stack ifStack;
    private static Stack tokenStack;
    protected static int current_line;
    protected static StringBuffer line;
    protected static int current_position;
    protected static boolean in_string;
    protected static boolean wide;
    static int error_count;
    public static int warning_count;
    public static String currentPragmaPrefix;
    public static String currentFile;

    public static void reset() {
        current_position = 1;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        line = new StringBuffer();
        ifStack.removeAllElements();
        tokenStack.removeAllElements();
        defines.clear();
    }

    public static void init() throws IOException {
        defines.put("JACORB_IDL_1_4", "");
        keywords.put("abstract", new Integer(2));
        keywords.put("any", new Integer(3));
        keywords.put("attribute", new Integer(4));
        keywords.put("boolean", new Integer(5));
        keywords.put("case", new Integer(6));
        keywords.put("char", new Integer(7));
        keywords.put("const", new Integer(8));
        keywords.put("context", new Integer(9));
        keywords.put("custom", new Integer(10));
        keywords.put("default", new Integer(11));
        keywords.put("double", new Integer(12));
        keywords.put("enum", new Integer(13));
        keywords.put("exception", new Integer(14));
        keywords.put("factory", new Integer(15));
        keywords.put("FALSE", new Integer(16));
        keywords.put("fixed", new Integer(17));
        keywords.put("float", new Integer(18));
        keywords.put("getraises", new Integer(19));
        keywords.put("in", new Integer(20));
        keywords.put("inout", new Integer(21));
        keywords.put("interface", new Integer(22));
        keywords.put("local", new Integer(23));
        keywords.put("long", new Integer(24));
        keywords.put("module", new Integer(25));
        keywords.put("native", new Integer(26));
        keywords.put("Object", new Integer(27));
        keywords.put("octet", new Integer(28));
        keywords.put("oneway", new Integer(29));
        keywords.put("out", new Integer(30));
        keywords.put("private", new Integer(31));
        keywords.put("public", new Integer(32));
        keywords.put("pseudo", new Integer(33));
        keywords.put("raises", new Integer(34));
        keywords.put("readonly", new Integer(35));
        keywords.put("sequence", new Integer(37));
        keywords.put("setraises", new Integer(36));
        keywords.put("short", new Integer(38));
        keywords.put("string", new Integer(39));
        keywords.put("struct", new Integer(40));
        keywords.put("supports", new Integer(41));
        keywords.put("switch", new Integer(42));
        keywords.put("TRUE", new Integer(43));
        keywords.put("truncatable", new Integer(44));
        keywords.put("typedef", new Integer(45));
        keywords.put("typeprefix", new Integer(46));
        keywords.put("unsigned", new Integer(47));
        keywords.put("union", new Integer(48));
        keywords.put("ValueBase", new Integer(49));
        keywords.put("valuetype", new Integer(50));
        keywords.put("void", new Integer(51));
        keywords.put("wchar", new Integer(52));
        keywords.put("wstring", new Integer(53));
        keywords.put("::", new Integer(79));
        keywords.put("<<", new Integer(81));
        keywords.put(">>", new Integer(80));
        keywords.put("L\"", new Integer(82));
        Enumeration e = keywords.keys();
        while (e.hasMoreElements()) {
            String keyword = (String)e.nextElement();
            String keyword_lower_case = keyword.toLowerCase();
            keywords_lower_case.put(keyword_lower_case, keyword);
        }
        char_symbols.put(new Integer(59), new Integer(54));
        char_symbols.put(new Integer(44), new Integer(55));
        char_symbols.put(new Integer(42), new Integer(56));
        char_symbols.put(new Integer(46), new Integer(57));
        char_symbols.put(new Integer(58), new Integer(58));
        char_symbols.put(new Integer(61), new Integer(59));
        char_symbols.put(new Integer(43), new Integer(60));
        char_symbols.put(new Integer(45), new Integer(61));
        char_symbols.put(new Integer(123), new Integer(64));
        char_symbols.put(new Integer(125), new Integer(65));
        char_symbols.put(new Integer(40), new Integer(62));
        char_symbols.put(new Integer(41), new Integer(63));
        char_symbols.put(new Integer(91), new Integer(66));
        char_symbols.put(new Integer(93), new Integer(67));
        char_symbols.put(new Integer(60), new Integer(68));
        char_symbols.put(new Integer(62), new Integer(69));
        char_symbols.put(new Integer(39), new Integer(70));
        char_symbols.put(new Integer(34), new Integer(71));
        char_symbols.put(new Integer(92), new Integer(72));
        char_symbols.put(new Integer(94), new Integer(74));
        char_symbols.put(new Integer(38), new Integer(75));
        char_symbols.put(new Integer(47), new Integer(76));
        char_symbols.put(new Integer(37), new Integer(77));
        char_symbols.put(new Integer(126), new Integer(78));
        char_symbols.put(new Integer(124), new Integer(73));
        char_symbols.put(new Integer(32), new Integer(83));
        java_keywords.add("abstract");
        java_keywords.add("assert");
        java_keywords.add("boolean");
        java_keywords.add("break");
        java_keywords.add("byte");
        java_keywords.add("case");
        java_keywords.add("catch");
        java_keywords.add("char");
        java_keywords.add("class");
        java_keywords.add("const");
        java_keywords.add("continue");
        java_keywords.add("default");
        java_keywords.add("do");
        java_keywords.add("double");
        java_keywords.add("else");
        java_keywords.add("enum");
        java_keywords.add("extends");
        java_keywords.add("false");
        java_keywords.add("final");
        java_keywords.add("finally");
        java_keywords.add("float");
        java_keywords.add("for");
        java_keywords.add("goto");
        java_keywords.add("if");
        java_keywords.add("implements");
        java_keywords.add("import");
        java_keywords.add("instanceof");
        java_keywords.add("int");
        java_keywords.add("interface");
        java_keywords.add("long");
        java_keywords.add("native");
        java_keywords.add("new");
        java_keywords.add("null");
        java_keywords.add("package");
        java_keywords.add("private");
        java_keywords.add("protected");
        java_keywords.add("public");
        java_keywords.add("return");
        java_keywords.add("short");
        java_keywords.add("static");
        java_keywords.add("strictfp");
        java_keywords.add("super");
        java_keywords.add("switch");
        java_keywords.add("synchronized");
        java_keywords.add("true");
        java_keywords.add("this");
        java_keywords.add("throw");
        java_keywords.add("throws");
        java_keywords.add("transient");
        java_keywords.add("try");
        java_keywords.add("void");
        java_keywords.add("volatile");
        java_keywords.add("while");
        java_keywords.add("clone");
        java_keywords.add("equals");
        java_keywords.add("finalize");
        java_keywords.add("getClass");
        java_keywords.add("hashCode");
        java_keywords.add("notify");
        java_keywords.add("notifyAll");
        java_keywords.add("toString");
        java_keywords.add("wait");
        ifStack.push(new Boolean(true));
        try {
            next_char = GlobalInputStream.read();
        }
        catch (Exception e2) {
            parser.fatal_error("Cannot read from file " + GlobalInputStream.currentFile().getAbsolutePath() + ", please check file name.", null);
        }
        next_char2 = next_char == -1 ? -1 : GlobalInputStream.read();
    }

    public static void define(String symbol2, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug("Defining: " + symbol2 + " as " + value);
        }
        defines.put(symbol2, value);
    }

    public static void undefine(String symbol2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Un-defining: " + symbol2);
        }
        defines.remove(symbol2);
    }

    public static String defined(String symbol2) {
        return (String)defines.get(symbol2);
    }

    public static int currentLine() {
        return current_line;
    }

    public static PositionInfo getPosition() {
        return new PositionInfo(current_line, current_position, currentPragmaPrefix, line.toString(), GlobalInputStream.currentFile());
    }

    public static void restorePosition(PositionInfo p) {
        current_line = p.line_no;
        currentPragmaPrefix = p.pragma_prefix;
        current_position = 0;
    }

    protected static void advance() throws IOException {
        int old_char = next_char;
        next_char = next_char2;
        next_char2 = GlobalInputStream.read();
        line.append((char)old_char);
        ++current_position;
        if (old_char == 10) {
            ++current_line;
            current_position = 1;
            line = new StringBuffer();
        }
    }

    public static void emit_error(String message) {
        if (parser.getLogger().isErrorEnabled()) {
            if (GlobalInputStream.currentFile() != null) {
                parser.getLogger().error(GlobalInputStream.currentFile().getAbsolutePath() + ", line: " + current_line + "(" + current_position + "): " + message + "\n\t" + line.toString());
            } else {
                parser.getLogger().error(message);
            }
        }
        ++error_count;
    }

    public static void emit_error(String message, str_token t) {
        if (t == null) {
            lexer.emit_error(message);
        } else {
            if (parser.getLogger().isErrorEnabled()) {
                logger.error(t.fileName + ", line:" + t.line_no + "(" + t.char_pos + "): " + message + "\n\t" + t.line_val);
            }
            ++error_count;
        }
    }

    public static void emit_warn(String message) {
        if (parser.getLogger().isWarnEnabled()) {
            logger.warn(message + " at " + current_line + "(" + current_position + "): \"" + line.toString() + "\"");
        }
        ++warning_count;
    }

    public static void emit_warn(String message, str_token t) {
        if (t == null) {
            lexer.emit_warn(message);
        } else {
            if (parser.getLogger().isWarnEnabled()) {
                logger.warn(" at " + t.fileName + ", line:" + t.line_no + "(" + t.char_pos + "): " + message + "\n\t" + t.line_val);
            }
            ++warning_count;
        }
    }

    protected static boolean id_start_char(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95;
    }

    protected static boolean id_char(int ch) {
        return lexer.id_start_char(ch) || ch == 95 || ch >= 48 && ch <= 57;
    }

    protected static int find_single_char(int ch) {
        Integer result = (Integer)char_symbols.get(new Integer((char)ch));
        if (result == null) {
            return -1;
        }
        return result;
    }

    protected static void swallow_comment() throws IOException {
        if (next_char2 == 42) {
            lexer.advance();
            lexer.advance();
            while (true) {
                if (next_char == -1) {
                    lexer.emit_error("Specification file ends inside a comment", null);
                    return;
                }
                if (next_char == 42 && next_char2 == 47) {
                    lexer.advance();
                    lexer.advance();
                    return;
                }
                lexer.advance();
            }
        }
        if (next_char2 == 47) {
            lexer.advance();
            lexer.advance();
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            return;
        }
        lexer.emit_error("Malformed comment in specification -- ignored", null);
        lexer.advance();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void preprocess() throws IOException {
        block44: {
            String dir;
            block53: {
                String name;
                block55: {
                    block54: {
                        block52: {
                            boolean b;
                            block51: {
                                block50: {
                                    block49: {
                                        block48: {
                                            String defineStr;
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        if (next_char == -1) {
                                                            lexer.emit_error("Specification file ends inside a preprocessor directive", null);
                                                            return;
                                                        }
                                                        if (next_char != 35) {
                                                            lexer.emit_error("expected #, got " + (char)next_char + " instead!", null);
                                                        } else {
                                                            lexer.advance();
                                                        }
                                                        while (32 == next_char || 9 == next_char) {
                                                            lexer.advance();
                                                        }
                                                        dir = lexer.get_string();
                                                        if (dir.equals("include")) {
                                                            if (!conditionalCompilation) {
                                                                return;
                                                            }
                                                            lexer.swallow_whitespace();
                                                            boolean useIncludePath = next_char == 60;
                                                            lexer.advance();
                                                            String fname = lexer.get_string();
                                                            if (useIncludePath && next_char != 62) {
                                                                lexer.emit_error("Syntax error in #include directive, expecting '>'");
                                                            } else if (!useIncludePath && next_char != 34) {
                                                                lexer.emit_error("Syntax error in #include directive, expecting \"");
                                                            }
                                                            GlobalInputStream.include(fname, next_char2, useIncludePath);
                                                            current_line = 0;
                                                            lexer.advance();
                                                            lexer.advance();
                                                            return;
                                                        }
                                                        if (!dir.equals("define")) break block45;
                                                        if (!conditionalCompilation) {
                                                            return;
                                                        }
                                                        lexer.swallow_whitespace();
                                                        String name2 = lexer.get_string();
                                                        StringBuffer text = new StringBuffer();
                                                        if (next_char == 32) {
                                                            lexer.advance();
                                                        }
                                                        while (next_char != 10) {
                                                            if (next_char == 92) {
                                                                lexer.advance();
                                                                lexer.advance();
                                                            }
                                                            text.append((char)next_char);
                                                            lexer.advance();
                                                        }
                                                        lexer.define(name2, text.toString());
                                                        break block44;
                                                    }
                                                    if (!dir.equals("error")) break block46;
                                                    if (!conditionalCompilation) {
                                                        return;
                                                    }
                                                    lexer.advance();
                                                    String name3 = lexer.get_string();
                                                    lexer.emit_error(name3);
                                                    break block44;
                                                }
                                                if (!dir.equals("undef")) break block47;
                                                if (!conditionalCompilation) {
                                                    return;
                                                }
                                                lexer.swallow_whitespace();
                                                String name4 = lexer.get_string();
                                                lexer.undefine(name4);
                                                break block44;
                                            }
                                            if (!dir.equals("if") && !dir.equals("elif")) break block48;
                                            if (!dir.equals("elif")) {
                                                ifStack.push(new Boolean(conditionalCompilation));
                                                if (!conditionalCompilation) {
                                                    return;
                                                }
                                            }
                                            lexer.swallow_whitespace();
                                            boolean straightDefined = true;
                                            if (33 == next_char) {
                                                lexer.advance();
                                                straightDefined = false;
                                            }
                                            if ((defineStr = lexer.get_string_no_paren()).equals("defined")) {
                                                boolean brackets;
                                                lexer.swallow_whitespace();
                                                boolean bl = brackets = 40 == next_char;
                                                if (brackets) {
                                                    lexer.advance();
                                                    lexer.swallow_whitespace();
                                                }
                                                String name5 = lexer.get_string_no_paren();
                                                if (brackets) {
                                                    lexer.swallow_whitespace();
                                                    if (logger.isDebugEnabled()) {
                                                        logger.debug("next char: " + next_char);
                                                    }
                                                    if (41 != next_char) {
                                                        lexer.emit_error("Expected ) terminating #if defined", null);
                                                        return;
                                                    }
                                                    lexer.advance();
                                                }
                                                conditionalCompilation = straightDefined ? null != lexer.defined(name5) : null == lexer.defined(name5);
                                                break block44;
                                            } else if (defineStr.equals("0")) {
                                                conditionalCompilation = false;
                                                break block44;
                                            } else {
                                                if (!defineStr.equals("1")) {
                                                    lexer.emit_error("Expected \"defined\" following #if: " + dir, null);
                                                    return;
                                                }
                                                conditionalCompilation = true;
                                            }
                                            break block44;
                                        }
                                        if (!dir.equals("ifdef")) break block49;
                                        ifStack.push(new Boolean(conditionalCompilation));
                                        if (!conditionalCompilation) {
                                            return;
                                        }
                                        lexer.swallow_whitespace();
                                        String name6 = lexer.get_string();
                                        conditionalCompilation = lexer.defined(name6) != null;
                                        break block44;
                                    }
                                    if (!dir.equals("ifndef")) break block50;
                                    ifStack.push(new Boolean(conditionalCompilation));
                                    if (!conditionalCompilation) {
                                        return;
                                    }
                                    lexer.swallow_whitespace();
                                    String name7 = lexer.get_string();
                                    conditionalCompilation = lexer.defined(name7) == null;
                                    break block44;
                                }
                                if (!dir.equals("else")) break block51;
                                if (((Boolean)ifStack.peek()).booleanValue()) {
                                    conditionalCompilation = !conditionalCompilation;
                                }
                                break block44;
                            }
                            if (!dir.equals("endif")) break block52;
                            conditionalCompilation = b = ((Boolean)ifStack.pop()).booleanValue();
                            break block44;
                        }
                        if (!dir.equals("pragma")) break block53;
                        if (!conditionalCompilation) {
                            return;
                        }
                        lexer.swallow_whitespace();
                        name = lexer.get_string();
                        if (!name.equals("prefix")) break block54;
                        lexer.swallow_whitespace();
                        currentPragmaPrefix = lexer.get_string();
                        break block44;
                    }
                    if (!name.equals("version")) break block55;
                    lexer.advance();
                    String vname = lexer.get_string();
                    lexer.advance();
                    String version = lexer.get_string();
                    String existingVersion = (String)parser.currentScopeData().versionMap.get(vname);
                    if (existingVersion == null) {
                        parser.currentScopeData().versionMap.put(vname, version);
                    } else if (!existingVersion.equals(version)) {
                        lexer.emit_error("Version re-declaration with different value: #pragma version " + version, null);
                    }
                    String iname = (String)parser.currentScopeData().idMap.get(vname);
                    if (iname != null && !version.equals(iname.substring(1 + iname.lastIndexOf(58)))) {
                        lexer.emit_error("Declaring version with different version to already declared ID for " + name, null);
                    }
                    break block44;
                }
                if (name.equals("ID")) {
                    lexer.advance();
                    String iname = lexer.get_string();
                    lexer.advance();
                    String id = lexer.get_string();
                    String existingID = (String)parser.currentScopeData().idMap.get(iname);
                    if (existingID == null) {
                        parser.currentScopeData().idMap.put(iname, id);
                    } else if (!existingID.equals(id)) {
                        lexer.emit_error("ID re-declaration with different value: #pragma id " + id, null);
                    }
                    if (parser.currentScopeData().versionMap.get(iname) != null && !((String)parser.currentScopeData().versionMap.get(iname)).equals(id.substring(1 + id.lastIndexOf(58)))) {
                        lexer.emit_error("Declaring ID with different version to already declared version for " + name, null);
                    }
                    break block44;
                } else if (name.equals("inhibit_code_generation")) {
                    parser.setInhibitionState(true);
                    break block44;
                } else {
                    lexer.emit_warn("Unknown pragma, ignoring: #pragma " + name, null);
                }
                break block44;
            }
            lexer.emit_error("Unrecognized preprocessor directive " + dir, null);
        }
        while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
            lexer.advance();
        }
    }

    private static String get_string_no_paren() throws IOException {
        StringBuffer sb = new StringBuffer();
        char c = (char)next_char;
        while (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f' && c != '\uffffffff' && c != '\"' && c != '<' && c != '>' && c != '(' && c != ')') {
            sb.append(c);
            lexer.advance();
            c = (char)next_char;
        }
        return sb.toString();
    }

    private static String get_string() throws IOException {
        StringBuffer sb = new StringBuffer("");
        if (next_char == 34) {
            lexer.advance();
            while (next_char != 34) {
                if (next_char == -1) {
                    lexer.emit_error("Unexpected EOF in string");
                }
                sb.append((char)next_char);
                lexer.advance();
            }
        } else {
            while (next_char != 32 && next_char != 9 && next_char != 13 && next_char != 10 && next_char != 12 && next_char != -1 && next_char != 34 && next_char != 60 && next_char != 62) {
                sb.append((char)next_char);
                lexer.advance();
            }
        }
        return sb.toString();
    }

    protected static token do_symbol() throws IOException {
        StringBuffer result = new StringBuffer();
        Integer keyword_num = null;
        char[] buffer = new char[]{(char)next_char};
        result.append(buffer, 0, 1);
        lexer.advance();
        while (lexer.id_char(next_char)) {
            buffer[0] = (char)next_char;
            result.append(buffer, 0, 1);
            lexer.advance();
        }
        String result_str = result.toString();
        String text = lexer.defined(result_str);
        if (text != null) {
            char[] next = new char[]{(char)next_char, (char)next_char2};
            GlobalInputStream.insert(text + new String(next));
            lexer.advance();
            lexer.advance();
            return null;
        }
        keyword_num = (Integer)keywords.get(result_str);
        if (keyword_num != null) {
            if (lexer.isScope(result_str)) {
                parser.openScope();
            }
            return new token(keyword_num);
        }
        if (null != (result_str = lexer.checkIdentifier(result_str))) {
            return new str_token(84, result_str, lexer.getPosition(), GlobalInputStream.currentFile().getName());
        }
        return null;
    }

    private static boolean isScope(String keyword) {
        return keyword.equals("module") || keyword.equals("interface") || keyword.equals("struct") || keyword.equals("exception") || keyword.equals("union");
    }

    public static String checkIdentifier(String str) {
        if (logger.isInfoEnabled()) {
            logger.info("checking identifier " + str);
        }
        if (str.charAt(0) == '_') {
            str = str.substring(1);
        } else {
            String colliding_keyword = null;
            colliding_keyword = parser.strict_names ? (String)keywords_lower_case.get(str.toLowerCase()) : (String)keywords.get(str);
            if (colliding_keyword != null) {
                lexer.emit_error("Identifier " + str + " collides with keyword " + colliding_keyword + ".");
                return null;
            }
        }
        if (lexer.needsJavaEscape(str)) {
            str = "_" + str;
        }
        return str;
    }

    private static boolean needsJavaEscape(String s) {
        return java_keywords.contains(s);
    }

    public static boolean strictJavaEscapeCheck(String s) {
        return !s.equals("Helper") && s.endsWith("Helper") || !s.equals("Holder") && s.endsWith("Holder") || !s.equals("Operations") && s.endsWith("Operations") || !s.equals("Package") && s.endsWith("Package") || !s.equals("POA") && s.endsWith("POA") || !s.equals("POATie") && s.endsWith("POATie");
    }

    public static boolean needsJavaEscape(Module m) {
        String s = m.pack_name;
        if (logger.isDebugEnabled()) {
            logger.debug("checking module name " + s);
        }
        return lexer.strictJavaEscapeCheck(s);
    }

    public static token next_token() throws IOException {
        parser.set_included(GlobalInputStream.includeState());
        token result = lexer.real_next_token();
        return result;
    }

    private static void swallow_whitespace() throws IOException {
        while (next_char == 32 || next_char == 9 || next_char == 10 || next_char == 12 || next_char == 13) {
            lexer.advance();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static token real_next_token() throws IOException {
        if (!tokenStack.empty()) {
            return (token)tokenStack.pop();
        }
        while (true) {
            block100: {
                block92: {
                    token t;
                    int sym_num;
                    block93: {
                        block96: {
                            block94: {
                                block98: {
                                    char c;
                                    char uni4;
                                    char uni3;
                                    char uni1;
                                    block91: {
                                        block99: {
                                            block97: {
                                                char c2;
                                                block95: {
                                                    char c3;
                                                    if (in_string) break block92;
                                                    lexer.swallow_whitespace();
                                                    if ((char)next_char == '#') {
                                                        lexer.preprocess();
                                                        continue;
                                                    }
                                                    if (next_char == 47 && (next_char2 == 42 || next_char2 == 47)) {
                                                        lexer.swallow_comment();
                                                        continue;
                                                    }
                                                    if (!conditionalCompilation) {
                                                        lexer.advance();
                                                        if (next_char != -1) continue;
                                                        lexer.emit_error("EOF in conditional compilation!", null);
                                                        return null;
                                                    }
                                                    if (next_char == 58) {
                                                        if (next_char2 == 58) {
                                                            lexer.advance();
                                                            lexer.advance();
                                                            return new token(79);
                                                        }
                                                        lexer.advance();
                                                        return new token(58);
                                                    }
                                                    if (next_char == 76 && (next_char2 == 34 || next_char2 == 39)) {
                                                        wide = true;
                                                        lexer.advance();
                                                        if (next_char2 == 34) {
                                                            lexer.advance();
                                                            in_string = true;
                                                            return new token(82);
                                                        }
                                                    }
                                                    if (next_char == 60) {
                                                        if (next_char2 == 60) {
                                                            lexer.advance();
                                                            lexer.advance();
                                                            return new token(81);
                                                        }
                                                        lexer.advance();
                                                        return new token(68);
                                                    }
                                                    if (next_char == 62) {
                                                        if (next_char2 == 62) {
                                                            lexer.advance();
                                                            lexer.advance();
                                                            return new token(80);
                                                        }
                                                        lexer.advance();
                                                        return new token(69);
                                                    }
                                                    if (next_char == 48) {
                                                        int radix = 8;
                                                        int digit = 0;
                                                        lexer.advance();
                                                        if (next_char == 46) {
                                                            StringBuffer stringBuffer = new StringBuffer("0.");
                                                            lexer.advance();
                                                            while (next_char >= 48 && next_char <= 57) {
                                                                stringBuffer.append((char)next_char);
                                                                lexer.advance();
                                                            }
                                                            float f_val = new Float(stringBuffer.toString()).floatValue();
                                                            return new float_token(88, f_val);
                                                        }
                                                        if (next_char == 120 || next_char == 88) {
                                                            lexer.advance();
                                                            radix = 16;
                                                        }
                                                        StringBuffer stringBuffer = new StringBuffer("0");
                                                        digit = Character.digit((char)next_char, radix);
                                                        while (digit != -1) {
                                                            stringBuffer.append((char)next_char);
                                                            lexer.advance();
                                                            digit = Character.digit((char)next_char, radix);
                                                        }
                                                        String str = stringBuffer.toString();
                                                        try {
                                                            return new int_token(86, Integer.parseInt(str, radix));
                                                        }
                                                        catch (NumberFormatException ex) {
                                                            try {
                                                                return new long_token(87, Long.parseLong(str, radix));
                                                            }
                                                            catch (NumberFormatException ex2) {
                                                                lexer.emit_error("Invalid octal/hex value:  " + str);
                                                                return null;
                                                            }
                                                        }
                                                    }
                                                    if (lexer.isDigit((char)next_char) || next_char == 46 || next_char == 45 && lexer.isDigit((char)next_char2)) {
                                                        StringBuffer value = new StringBuffer();
                                                        StringBuffer fraction = null;
                                                        if (next_char == 45) {
                                                            value.append((char)next_char);
                                                            lexer.advance();
                                                        }
                                                        while (next_char >= 48 && next_char <= 57) {
                                                            value.append((char)next_char);
                                                            lexer.advance();
                                                        }
                                                        if (next_char == 46) {
                                                            fraction = new StringBuffer();
                                                            lexer.advance();
                                                            while (next_char >= 48 && next_char <= 57) {
                                                                fraction.append((char)next_char);
                                                                lexer.advance();
                                                            }
                                                        }
                                                        if (next_char == 101 || next_char == 69) {
                                                            if (fraction == null) {
                                                                fraction = new StringBuffer();
                                                            }
                                                            fraction.append('e');
                                                            lexer.advance();
                                                            if (next_char == 45 || next_char == 43) {
                                                                fraction.append((char)next_char);
                                                                lexer.advance();
                                                            }
                                                            while (next_char >= 48 && next_char <= 57) {
                                                                fraction.append((char)next_char);
                                                                lexer.advance();
                                                            }
                                                            if (fraction.length() != 1) return new float_token(88, Float.valueOf(value.toString() + "." + fraction.toString()).floatValue());
                                                            lexer.emit_error("Empty exponent in float/double.");
                                                            continue;
                                                        }
                                                        if (next_char == 100 || next_char == 68) {
                                                            lexer.advance();
                                                            if (fraction == null) {
                                                                fraction = new StringBuffer();
                                                            }
                                                            BigDecimal bigDecimal = new BigDecimal(value.toString() + "." + fraction.toString());
                                                            return new fixed_token(89, bigDecimal);
                                                        }
                                                        if (fraction == null) {
                                                            void var3_17;
                                                            Object var3_13 = null;
                                                            String str = value.toString();
                                                            try {
                                                                int_token int_token2 = new int_token(86, Integer.parseInt(str));
                                                                return var3_17;
                                                            }
                                                            catch (NumberFormatException ex) {
                                                                try {
                                                                    long_token long_token2 = new long_token(87, Long.parseLong(str));
                                                                    return var3_17;
                                                                }
                                                                catch (NumberFormatException ex2) {
                                                                    try {
                                                                        fixed_token fixed_token2 = new fixed_token(89, new BigDecimal(str));
                                                                        return var3_17;
                                                                    }
                                                                    catch (NumberFormatException ex3) {
                                                                        lexer.emit_error("Invalid long value:  " + str);
                                                                    }
                                                                }
                                                            }
                                                            return var3_17;
                                                        }
                                                        try {
                                                            float f = Float.valueOf(value.toString() + "." + fraction.toString()).floatValue();
                                                            return new float_token(88, f);
                                                        }
                                                        catch (NumberFormatException numberFormatException) {
                                                            lexer.emit_error("Unexpected symbol:  " + value.toString() + "." + fraction.toString());
                                                        }
                                                    }
                                                    sym_num = lexer.find_single_char(next_char);
                                                    if ((char)next_char == '\"') {
                                                        in_string = true;
                                                        lexer.advance();
                                                        return new token(71);
                                                    }
                                                    if ((char)next_char != '\'') break block93;
                                                    lexer.advance();
                                                    t = null;
                                                    if (next_char != 92) break block94;
                                                    lexer.advance();
                                                    if (!lexer.isDigit((char)next_char)) break block95;
                                                    char octal1 = '0';
                                                    int n = 48;
                                                    char octal3 = (char)next_char;
                                                    if (lexer.isDigit((char)next_char2)) {
                                                        lexer.advance();
                                                        char c4 = octal3;
                                                        octal3 = (char)next_char;
                                                        if (lexer.isDigit((char)next_char2)) {
                                                            lexer.advance();
                                                            octal1 = c4;
                                                            c3 = octal3;
                                                            octal3 = (char)next_char;
                                                        }
                                                    }
                                                    t = new char_token(85, (char)Integer.parseInt(new String(new char[]{octal1, c3, octal3}), 8));
                                                    break block96;
                                                }
                                                if ((char)next_char != 'x') break block97;
                                                lexer.advance();
                                                char hex1 = '0';
                                                char c5 = (char)next_char;
                                                if (lexer.isHexLetterOrDigit((char)next_char2)) {
                                                    lexer.advance();
                                                    hex1 = c5;
                                                    c2 = (char)next_char;
                                                } else if ((char)next_char2 != '\'') {
                                                    lexer.emit_error("Illegal hex character");
                                                    return null;
                                                }
                                                t = new char_token(85, (char)Integer.parseInt(new String(new char[]{hex1, c2}), 16));
                                                break block96;
                                            }
                                            if ((char)next_char != 'u') break block98;
                                            if (!wide) {
                                                lexer.emit_error("Unicode characters are only legal with wide character");
                                                return null;
                                            }
                                            lexer.advance();
                                            uni1 = '0';
                                            int n = 48;
                                            uni3 = '0';
                                            uni4 = (char)next_char;
                                            if (!lexer.isHexLetterOrDigit((char)next_char2)) break block99;
                                            lexer.advance();
                                            uni3 = uni4;
                                            uni4 = (char)next_char;
                                            if (lexer.isHexLetterOrDigit((char)next_char2)) {
                                                lexer.advance();
                                                char c6 = uni3;
                                                uni3 = uni4;
                                                uni4 = (char)next_char;
                                                if (lexer.isHexLetterOrDigit((char)next_char2)) {
                                                    lexer.advance();
                                                    uni1 = c6;
                                                    c = uni3;
                                                    uni3 = uni4;
                                                    uni4 = (char)next_char;
                                                    break block91;
                                                } else if ((char)next_char2 != '\'') {
                                                    lexer.emit_error("Illegal unicode character");
                                                    return null;
                                                }
                                                break block91;
                                            } else if ((char)next_char2 != '\'') {
                                                lexer.emit_error("Illegal unicode character");
                                                return null;
                                            }
                                            break block91;
                                        }
                                        if ((char)next_char2 != '\'') {
                                            lexer.emit_error("Illegal unicode character");
                                            return null;
                                        }
                                    }
                                    t = new char_token(85, (char)Integer.parseInt(new String(new char[]{uni1, c, uni3, uni4}), 16));
                                    break block96;
                                }
                                switch (next_char) {
                                    case 110: {
                                        t = new char_token(85, '\n');
                                        break block96;
                                    }
                                    case 116: {
                                        t = new char_token(85, '\t');
                                        break block96;
                                    }
                                    case 118: {
                                        t = new char_token(85, '\u000b');
                                        break block96;
                                    }
                                    case 98: {
                                        t = new char_token(85, '\b');
                                        break block96;
                                    }
                                    case 114: {
                                        t = new char_token(85, '\r');
                                        break block96;
                                    }
                                    case 102: {
                                        t = new char_token(85, '\f');
                                        break block96;
                                    }
                                    case 97: {
                                        t = new char_token(85, '\u0007');
                                        break block96;
                                    }
                                    case 92: {
                                        t = new char_token(85, '\\');
                                        break block96;
                                    }
                                    case 63: {
                                        t = new char_token(85, '?');
                                        break block96;
                                    }
                                    case 48: {
                                        t = new char_token(85, '\u0000');
                                        break block96;
                                    }
                                    case 39: {
                                        t = new char_token(85, '\'');
                                        break block96;
                                    }
                                    case 34: {
                                        t = new char_token(85, '\"');
                                        break block96;
                                    }
                                    default: {
                                        lexer.emit_error("Invalid escape symbol '");
                                        return null;
                                    }
                                }
                            }
                            t = new char_token(85, (char)next_char);
                        }
                        lexer.advance();
                        if ((char)next_char == '\'') {
                            tokenStack.push(new token(70));
                            tokenStack.push(t);
                            lexer.advance();
                            wide = false;
                            return new token(70);
                        }
                        lexer.emit_error("Expecting closing '");
                        return null;
                    }
                    if (sym_num != -1) {
                        lexer.advance();
                        return new token(sym_num);
                    }
                    if (lexer.id_start_char(next_char)) {
                        t = lexer.do_symbol();
                        if (t == null) continue;
                        return t;
                    }
                    if (next_char == -1) {
                        return new token(0);
                    }
                    break block100;
                }
                if ((char)next_char == '\"') {
                    in_string = false;
                    lexer.advance();
                    return new token(71);
                }
                break;
            }
            lexer.emit_warn("Unrecognized character '" + new Character((char)next_char) + "'(" + next_char + ") -- ignored");
            lexer.advance();
        }
        StringBuffer result = new StringBuffer();
        char previous = ' ';
        do {
            if (next_char == 92) {
                switch (next_char2) {
                    case 97: {
                        result.append("\\007");
                        previous = 'a';
                        lexer.advance();
                        break;
                    }
                    case 118: {
                        result.append("\\013");
                        previous = 'v';
                        lexer.advance();
                        break;
                    }
                    case 63: {
                        result.append("?");
                        previous = '?';
                        lexer.advance();
                        break;
                    }
                    case 120: {
                        void var3_31;
                        lexer.advance();
                        lexer.advance();
                        String string = Integer.toOctalString(Integer.parseInt(new String(new char[]{(char)next_char, (char)next_char2}), 16));
                        if (string.length() != 3) {
                            void var3_29;
                            if (string.length() == 1) {
                                String string2 = "0" + string;
                            }
                            String string3 = "0" + (String)var3_29;
                        }
                        result.append("\\" + (String)var3_31);
                        previous = (char)next_char2;
                        lexer.advance();
                        break;
                    }
                    case 117: {
                        if (!wide) {
                            lexer.emit_error("Unicode characters are only legal with wide strings");
                            return null;
                        }
                        result.append((char)next_char);
                        result.append((char)next_char2);
                        lexer.advance();
                        lexer.advance();
                        char c = (char)next_char;
                        char uni2 = '0';
                        char uni3 = '0';
                        char uni4 = '0';
                        if (!lexer.isHexLetterOrDigit((char)next_char2)) {
                            lexer.emit_error("Illegal unicode character");
                            return null;
                        }
                        lexer.advance();
                        uni2 = (char)next_char;
                        if (!lexer.isHexLetterOrDigit((char)next_char2)) {
                            lexer.emit_error("Illegal unicode character");
                            return null;
                        }
                        lexer.advance();
                        uni3 = (char)next_char;
                        if (!lexer.isHexLetterOrDigit((char)next_char2)) {
                            lexer.emit_error("Illegal unicode character");
                            return null;
                        }
                        lexer.advance();
                        uni4 = (char)next_char;
                        previous = uni4;
                        result.append(c);
                        result.append(uni2);
                        result.append(uni3);
                        result.append(uni4);
                        break;
                    }
                    default: {
                        previous = (char)next_char;
                        result.append((char)next_char);
                        break;
                    }
                }
            } else {
                previous = (char)next_char;
                result.append((char)next_char);
            }
            lexer.advance();
        } while ((char)next_char != '\"' || previous == 92);
        wide = false;
        String string = result.toString();
        return new str_token(84, string, lexer.getPosition(), GlobalInputStream.currentFile().getName());
    }

    static boolean isDigit(char c) {
        boolean result = false;
        if (c >= '0' && c <= '9') {
            result = true;
        }
        return result;
    }

    private static boolean isHexLetterOrDigit(char c) {
        boolean result = false;
        if (c >= '0') {
            if (c <= '9') {
                result = true;
            } else if (c >= 'A') {
                if (c <= 'F') {
                    result = true;
                }
                if (c >= 'a' && c <= 'f') {
                    result = true;
                }
            }
        }
        return result;
    }

    static {
        keywords = new Hashtable();
        keywords_lower_case = new Hashtable();
        java_keywords = new HashSet();
        char_symbols = new Hashtable(25);
        defines = new Hashtable();
        conditionalCompilation = true;
        ifStack = new Stack();
        tokenStack = new Stack();
        current_line = 1;
        line = new StringBuffer();
        current_position = 1;
        in_string = false;
        wide = false;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        currentFile = "";
    }
}

