/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.classifiedstats;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.media.jai.ImageLayout;
import javax.media.jai.NullOpImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.jaitools.CollectionFactory;
import org.jaitools.media.jai.classifiedstats.ClassifiedStats;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.RangeUtils;
import org.jaitools.numeric.Statistic;
import org.jaitools.numeric.StreamingSampleStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifiedStatsOpImage
extends NullOpImage {
    private final Integer[] srcBands;
    private final ROI roi;
    private final Statistic[] stats;
    private int imageWidth;
    private int imageHeigth;
    private int imageMinY;
    private int imageMinX;
    private int imageMaxX;
    private int imageMaxY;
    private int imageMinTileX;
    private int imageMinTileY;
    private int imageMaxTileY;
    private int imageMaxTileX;
    private int imageTileHeight;
    private int imageTileWidth;
    private final Rectangle dataImageBounds;
    private final RenderedImage dataImage;
    private final RenderedImage[] classifierImages;
    private final RenderedImage[] pivotClassifierImages;
    private double[] noDataForClassifierImages;
    private double[] noDataForPivotClassifierImages;
    private final List<Range<Double>> ranges;
    private final List<Range<Double>> noDataRanges;
    private final boolean rangeLocalStats;
    private Range.Type rangesType;

    public ClassifiedStatsOpImage(RenderedImage dataImage, RenderedImage[] classifierImages, RenderedImage[] pivotClassifierImages, Map<?, ?> config, ImageLayout layout, Statistic[] stats, Integer[] bands, ROI roi, Collection<Range<Double>> ranges, Range.Type rangesType, boolean rangeLocalStats, Collection<Range<Double>> noDataRanges, Double[] noDataClassifiers, Double[] noDataPivotClassifiers) {
        super(dataImage, layout, config, 1);
        this.dataImage = dataImage;
        this.classifierImages = classifierImages;
        this.pivotClassifierImages = pivotClassifierImages;
        this.imageWidth = dataImage.getWidth();
        this.imageHeigth = dataImage.getHeight();
        this.imageTileWidth = Math.min(dataImage.getTileWidth(), this.imageWidth);
        this.imageTileHeight = Math.min(dataImage.getTileHeight(), this.imageHeigth);
        this.imageMinY = dataImage.getMinY();
        this.imageMinX = dataImage.getMinX();
        this.imageMaxX = this.imageMinX + this.imageWidth - 1;
        this.imageMaxY = this.imageMinY + this.imageHeigth - 1;
        this.imageMinTileX = dataImage.getMinTileX();
        this.imageMinTileY = dataImage.getMinTileY();
        this.imageMaxTileX = this.imageMinTileX + dataImage.getNumXTiles();
        this.imageMaxTileY = this.imageMinTileY + dataImage.getNumYTiles();
        this.dataImageBounds = new Rectangle(this.imageMinX, this.imageMinY, this.imageWidth, this.imageHeigth);
        this.stats = new Statistic[stats.length];
        System.arraycopy(stats, 0, this.stats, 0, stats.length);
        this.srcBands = new Integer[bands.length];
        System.arraycopy(bands, 0, this.srcBands, 0, bands.length);
        this.roi = roi;
        this.rangeLocalStats = rangeLocalStats;
        this.ranges = CollectionFactory.list();
        this.rangesType = rangesType;
        if (ranges != null && !ranges.isEmpty()) {
            for (Range<Double> r : ranges) {
                this.ranges.add(new Range<Double>(r));
            }
        }
        this.noDataRanges = CollectionFactory.list();
        if (noDataRanges != null && !noDataRanges.isEmpty()) {
            for (Range<Double> r : noDataRanges) {
                this.noDataRanges.add(new Range<Double>(r));
            }
        }
        if (noDataClassifiers != null) {
            this.noDataForClassifierImages = new double[noDataClassifiers.length];
            for (int i = 0; i < noDataClassifiers.length; ++i) {
                this.noDataForClassifierImages[i] = noDataClassifiers[i];
            }
        }
        if (noDataPivotClassifiers != null) {
            this.noDataForPivotClassifierImages = new double[noDataPivotClassifiers.length];
            for (int i = 0; i < noDataPivotClassifiers.length; ++i) {
                this.noDataForPivotClassifierImages[i] = noDataPivotClassifiers[i];
            }
        }
    }

    synchronized ClassifiedStats compileStatistics() {
        int i;
        ClassifiedStats classifiedStats = null;
        RandomIter dataIter = RandomIterFactory.create((RenderedImage)this.dataImage, (Rectangle)this.dataImageBounds);
        int numClassifiers = this.classifierImages.length;
        int numPivotClassifiers = this.pivotClassifierImages != null ? this.pivotClassifierImages.length : 0;
        ClassifierObject[] classifiers = new ClassifierObject[numClassifiers];
        for (int i2 = 0; i2 < numClassifiers; ++i2) {
            RandomIter classifierIter = RandomIterFactory.create((RenderedImage)this.classifierImages[i2], (Rectangle)this.dataImageBounds);
            boolean checkForNoData = this.noDataForClassifierImages != null && !Double.isNaN(this.noDataForClassifierImages[i2]);
            int noDataClassifierValue = checkForNoData ? (int)this.noDataForClassifierImages[i2] : 0;
            classifiers[i2] = new ClassifierObject(classifierIter, checkForNoData, noDataClassifierValue);
        }
        ClassifierObject[] pivotClassifiers = numPivotClassifiers > 0 ? new ClassifierObject[numPivotClassifiers] : null;
        for (i = 0; i < numPivotClassifiers; ++i) {
            RandomIter classifierIter = RandomIterFactory.create((RenderedImage)this.pivotClassifierImages[i], (Rectangle)this.dataImageBounds);
            boolean checkForNoData = this.noDataForPivotClassifierImages != null && !Double.isNaN(this.noDataForPivotClassifierImages[i]);
            int noDataClassifierValue = checkForNoData ? (int)this.noDataForPivotClassifierImages[i] : 0;
            pivotClassifiers[i] = new ClassifierObject(classifierIter, checkForNoData, noDataClassifierValue);
        }
        classifiedStats = !this.rangeLocalStats ? this.compileClassifiedStatistics(dataIter, classifiers, pivotClassifiers) : this.compileLocalRangeStatistics(dataIter, classifiers);
        dataIter.done();
        for (i = 0; i < numClassifiers; ++i) {
            classifiers[i].classifierIter.done();
        }
        for (i = 0; i < numPivotClassifiers; ++i) {
            pivotClassifiers[i].classifierIter.done();
        }
        return classifiedStats;
    }

    protected StreamingSampleStats setupStats(Map<MultiKey, StreamingSampleStats> resultsPerBand, MultiKey classifierKey, Range.Type rangesType, List<Range<Double>> ranges) {
        StreamingSampleStats sampleStats = new StreamingSampleStats(rangesType);
        for (Range<Double> r : ranges) {
            sampleStats.addRange(r);
        }
        for (Range<Double> r : this.noDataRanges) {
            sampleStats.addNoDataRange(r);
        }
        sampleStats.setStatistics(this.stats);
        resultsPerBand.put(classifierKey, sampleStats);
        return sampleStats;
    }

    private ClassifiedStats compileClassifiedStatistics(RandomIter dataIter, ClassifierObject[] classifiers, ClassifierObject[] pivotClassifiers) {
        ClassifiedStats classifiedStats = new ClassifiedStats();
        SortedMap<Integer, List<Map<MultiKey, StreamingSampleStats>>> results = CollectionFactory.sortedMap();
        int numPivots = pivotClassifiers != null ? pivotClassifiers.length : 0;
        for (Integer srcBand : this.srcBands) {
            if (numPivots > 0) {
                ArrayList pivotLists = new ArrayList(numPivots);
                for (int i = 0; i < numPivots; ++i) {
                    HashMap resultsPerBand = new HashMap();
                    pivotLists.add(resultsPerBand);
                }
                results.put(srcBand, pivotLists);
                continue;
            }
            HashMap resultsPerBand = new HashMap();
            List singleElement = Collections.singletonList(resultsPerBand);
            results.put(srcBand, singleElement);
        }
        Range.Type localRangeType = Range.Type.EXCLUDE;
        List<Range<Double>> localRanges = this.ranges;
        this.computeStatsOnTiles(dataIter, classifiers, pivotClassifiers, localRangeType, localRanges, results);
        for (Integer band : this.srcBands) {
            int numElements = numPivots > 0 ? numPivots : 1;
            List resultList = (List)results.get(band);
            for (int i = 0; i < numElements; ++i) {
                Map resultMap = (Map)resultList.get(i);
                Set classifierSetForBand = resultMap.keySet();
                for (MultiKey classifier : classifierSetForBand) {
                    classifiedStats.setResults(band, i, classifier, (StreamingSampleStats)resultMap.get(classifier));
                }
            }
        }
        return classifiedStats;
    }

    private ClassifiedStats compileLocalRangeStatistics(RandomIter dataIter, ClassifierObject[] classifiers) {
        ClassifiedStats classifiedStats = new ClassifiedStats();
        List rangesList = null;
        switch (this.rangesType) {
            case EXCLUDE: {
                List inRanges = RangeUtils.createComplement(RangeUtils.sort(this.ranges));
                rangesList = CollectionFactory.list();
                rangesList.addAll(inRanges);
                break;
            }
            case INCLUDE: {
                rangesList = CollectionFactory.list();
                rangesList.addAll(this.ranges);
                break;
            }
            case UNDEFINED: {
                throw new UnsupportedOperationException("Unable to compute range local statistics on UNDEFINED ranges type");
            }
        }
        Range.Type localRangeType = this.rangesType;
        for (Range range : rangesList) {
            SortedMap<Integer, List<Map<MultiKey, StreamingSampleStats>>> results = CollectionFactory.sortedMap();
            for (int index = 0; index < this.srcBands.length; ++index) {
                HashMap resultsPerBand = new HashMap();
                results.put(index, Collections.singletonList(resultsPerBand));
            }
            List<Range<Double>> localRanges = Collections.singletonList(range);
            this.computeStatsOnTiles(dataIter, classifiers, null, localRangeType, localRanges, results);
            HashSet classifKeys = new HashSet();
            for (Integer band : this.srcBands) {
                Set classifierSetForBand = ((Map)((List)results.get(band)).get(0)).keySet();
                classifKeys.addAll(classifierSetForBand);
            }
            for (int index = 0; index < this.srcBands.length; ++index) {
                for (MultiKey classifier : classifKeys) {
                    classifiedStats.setResults(this.srcBands[index], 0, classifier, (StreamingSampleStats)((Map)((List)results.get(index)).get(0)).get(classifier), localRanges);
                }
            }
        }
        return classifiedStats;
    }

    private void computeStatsOnTiles(RandomIter dataIter, ClassifierObject[] classifiers, ClassifierObject[] pivotClassifiers, Range.Type rangesType, List<Range<Double>> ranges, Map<Integer, List<Map<MultiKey, StreamingSampleStats>>> results) {
        int numClassifiers = classifiers.length;
        int numPivotClassifiers = pivotClassifiers != null ? pivotClassifiers.length : 0;
        double[] sampleValues = new double[this.dataImage.getSampleModel().getNumBands()];
        int pivotClassifiersIncrement = numPivotClassifiers > 0 ? 1 : 0;
        Integer[] keys = new Integer[numClassifiers + pivotClassifiersIncrement];
        Integer[] pivotKeys = new Integer[numPivotClassifiers];
        for (int tileY = this.imageMinTileY; tileY <= this.imageMaxTileY; ++tileY) {
            for (int tileX = this.imageMinTileX; tileX <= this.imageMaxTileX; ++tileX) {
                for (int tRow = 0; tRow < this.imageTileHeight; ++tRow) {
                    int row = tileY * this.imageTileHeight + tRow;
                    if (row < this.imageMinY || row > this.imageMaxY) continue;
                    for (int tCol = 0; tCol < this.imageTileWidth; ++tCol) {
                        int i;
                        int col = tileX * this.imageTileWidth + tCol;
                        if (col < this.imageMinX || col > this.imageMaxX || this.roi != null && !this.roi.contains(col, row)) continue;
                        boolean skipStats = false;
                        for (i = 0; i < numClassifiers; ++i) {
                            keys[i + pivotClassifiersIncrement] = classifiers[i].classifierIter.getSample(col, row, 0);
                            if (!classifiers[i].checkForNoData) continue;
                            skipStats = skipStats || keys[i + pivotClassifiersIncrement] == classifiers[i].noData;
                        }
                        for (i = 0; i < numPivotClassifiers; ++i) {
                            pivotKeys[i] = pivotClassifiers[i].classifierIter.getSample(col, row, 0);
                            if (!pivotClassifiers[i].checkForNoData) continue;
                            skipStats = skipStats || pivotKeys[i] == pivotClassifiers[i].noData;
                        }
                        if (skipStats) continue;
                        for (Integer band : this.srcBands) {
                            sampleValues[band.intValue()] = dataIter.getSampleDouble(col, row, band.intValue());
                            List<Map<MultiKey, StreamingSampleStats>> resultPerBand = results.get(band);
                            boolean goOn = true;
                            int i2 = 0;
                            while (goOn) {
                                MultiKey mk;
                                StreamingSampleStats sss;
                                Map<MultiKey, StreamingSampleStats> keyedElement = resultPerBand.get(i2);
                                if (numPivotClassifiers > 0) {
                                    keys[0] = pivotKeys[i2];
                                    if (i2 == numPivotClassifiers - 1) {
                                        goOn = false;
                                    }
                                } else {
                                    goOn = false;
                                }
                                if ((sss = keyedElement.get(mk = ClassifiedStatsOpImage.createMultiKey(keys))) == null) {
                                    sss = this.setupStats(keyedElement, mk, rangesType, ranges);
                                }
                                sss.offer(sampleValues[band]);
                                ++i2;
                            }
                        }
                    }
                }
            }
        }
    }

    private static final MultiKey createMultiKey(Integer[] keys) {
        int nKeys = keys.length;
        switch (nKeys) {
            case 2: {
                return new MultiKey(keys[0], keys[1]);
            }
            case 3: {
                return new MultiKey(keys[0], keys[1], keys[2]);
            }
            case 4: {
                return new MultiKey(keys[0], keys[1], keys[2], keys[3]);
            }
            case 5: {
                return new MultiKey(keys[0], keys[1], keys[2], keys[3], keys[4]);
            }
        }
        return new MultiKey(keys);
    }

    public Object getProperty(String name) {
        if ("ClassifiedStatsProperty".equalsIgnoreCase(name)) {
            return this.compileStatistics();
        }
        return super.getProperty(name);
    }

    public Class<?> getPropertyClass(String name) {
        if ("ClassifiedStatsProperty".equalsIgnoreCase(name)) {
            return Map.class;
        }
        return super.getPropertyClass(name);
    }

    public String[] getPropertyNames() {
        String[] names;
        int k = 0;
        String[] superNames = super.getPropertyNames();
        if (superNames != null) {
            names = new String[superNames.length + 1];
            for (String name : super.getPropertyNames()) {
                names[k++] = name;
            }
        } else {
            names = new String[1];
        }
        names[k] = "ClassifiedStatsProperty";
        return names;
    }

    private class ClassifierObject {
        RandomIter classifierIter;
        boolean checkForNoData;
        int noData;

        public ClassifierObject(RandomIter classifierIter, boolean checkForNoData, int noData) {
            this.classifierIter = classifierIter;
            this.checkForNoData = checkForNoData;
            this.noData = noData;
        }
    }
}

