/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.regionalize;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;
import org.jaitools.CollectionFactory;
import org.jaitools.imageutils.FillResult;
import org.jaitools.imageutils.FloodFiller;
import org.jaitools.media.jai.regionalize.Region;
import org.jaitools.tilecache.DiskMemTileCache;
import org.jaitools.tiledimage.DiskMemImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionalizeOpImage
extends PointOpImage {
    public static final int NO_REGION = 0;
    private boolean singleBand;
    private boolean diagonal;
    private int band;
    private double tolerance;
    private FloodFiller filler;
    private Map<Integer, Region> regions;
    private int currentID;
    private final DiskMemImage regionImage;
    private final ExecutorService executor;
    private final Object getTileLock = new Object();
    private final Object computeTileLock = new Object();
    private boolean[] tileComputed;

    public RegionalizeOpImage(RenderedImage source, Map config, ImageLayout layout, int band, double tolerance, boolean diagonal) {
        super(source, layout, config, false);
        if (this.getSampleModel().getDataType() != 3) {
            throw new IllegalStateException("destination sample model must be TYPE_INT");
        }
        this.band = band;
        this.tolerance = tolerance;
        this.singleBand = true;
        this.diagonal = diagonal;
        this.regionImage = new DiskMemImage(this.getWidth(), this.getHeight(), this.getSampleModel());
        this.setTileCache(this.regionImage.getTileCache());
        this.filler = new FloodFiller(source, band, this.regionImage, 0, tolerance, diagonal);
        this.regions = CollectionFactory.sortedMap();
        this.executor = Executors.newSingleThreadExecutor();
        this.tileComputed = new boolean[this.getNumXTiles() * this.getNumYTiles()];
        Arrays.fill(this.tileComputed, false);
        this.currentID = 1;
    }

    public Object getProperty(String name) {
        if ("regiondata".equalsIgnoreCase(name)) {
            List regionData = CollectionFactory.list();
            regionData.addAll(this.regions.values());
            return regionData;
        }
        return super.getProperty(name);
    }

    public Hashtable getProperties() {
        Hashtable<String, String> props = super.getProperties();
        if (props == null) {
            props = new Hashtable<String, String>();
        }
        props.put("regiondata", "dynamic");
        return props;
    }

    public Class<?> getPropertyClass(String name) {
        if ("regiondata".equalsIgnoreCase(name)) {
            return List.class;
        }
        return super.getPropertyClass(name);
    }

    public String[] getPropertyNames() {
        String[] superNames = super.getPropertyNames();
        int len = superNames != null ? superNames.length + 1 : 1;
        String[] names = new String[len];
        int k = 0;
        if (len > 1) {
            for (String name : superNames) {
                names[k++] = name;
            }
        }
        names[k] = "regiondata";
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster getTile(int tileX, int tileY) {
        Raster tile = null;
        if (tileX >= this.getMinTileX() && tileX <= this.getMaxTileX() && tileY >= this.getMinTileY() && tileY <= this.getMaxTileY()) {
            if (this.tileComputed[this.getTileIndex(tileX, tileY)]) {
                tile = this.regionImage.getTile(tileX, tileY);
            } else {
                Object object = this.getTileLock;
                synchronized (object) {
                    try {
                        tile = this.executor.submit(new ComputeTileTask(tileX, tileY)).get();
                    }
                    catch (ExecutionException execEx) {
                        throw new IllegalStateException(execEx);
                    }
                    catch (InterruptedException intEx) {
                        return null;
                    }
                }
            }
        }
        return tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Rectangle destRect = this.getTileRect(tileX, tileY);
        Object object = this.computeTileLock;
        synchronized (object) {
            int destY = destRect.y;
            for (int row = 0; row < destRect.height; ++row) {
                int destX = destRect.x;
                for (int col = 0; col < destRect.width; ++col) {
                    if (this.getRegionForPixel(destX, destY) == 0) {
                        FillResult fill = this.filler.fill(destX, destY, this.currentID);
                        this.regions.put(this.currentID, new Region(fill));
                        ++this.currentID;
                    }
                    ++destX;
                }
                ++destY;
            }
            this.tileComputed[this.getTileIndex((int)tileX, (int)tileY)] = true;
        }
        return this.regionImage.getTile(tileX, tileY);
    }

    private int getTileIndex(int tileX, int tileY) {
        return (tileY - this.getMinTileY()) * this.getNumXTiles() + (tileX - this.getMinTileX());
    }

    protected void addTileToCache(int tileX, int tileY, Raster tile) {
        throw new UnsupportedOperationException("this method should not be called !");
    }

    protected Raster getTileFromCache(int tileX, int tileY) {
        return this.regionImage.getTile(tileX, tileY);
    }

    public void setTileCache(TileCache cache) {
        if (cache == null || !(cache instanceof DiskMemTileCache)) {
            throw new IllegalArgumentException("cache must be an instance of DiskMemTileCache");
        }
        super.setTileCache(cache);
    }

    private int getRegionForPixel(int x, int y) {
        int tileX = this.XToTileX(x);
        int tileY = this.YToTileY(y);
        Raster tile = this.regionImage.getTile(tileX, tileY);
        assert (tile != null);
        return tile.getSample(x, y, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComputeTileTask
    implements Callable<Raster> {
        int tileX;
        int tileY;

        ComputeTileTask(int tileX, int tileY) {
            this.tileX = tileX;
            this.tileY = tileY;
        }

        @Override
        public Raster call() throws Exception {
            return RegionalizeOpImage.this.computeTile(this.tileX, this.tileY);
        }
    }
}

