/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.regionalize;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.jaitools.media.jai.regionalize.RegionalizeOpImage;

public class RegionalizeRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        int tileHeight;
        int tileWidth;
        RenderedImage src = paramBlock.getRenderedSource(0);
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        if (layout == null) {
            layout = new ImageLayout();
        }
        if ((tileWidth = layout.getTileWidth(null)) == 0) {
            tileWidth = JAI.getDefaultTileSize().width;
        }
        if ((tileHeight = layout.getTileHeight(null)) == 0) {
            tileHeight = JAI.getDefaultTileSize().height;
        }
        ComponentSampleModel sm = new ComponentSampleModel(3, tileWidth, tileHeight, 1, tileWidth, new int[]{0});
        layout.setSampleModel((SampleModel)sm);
        int band = paramBlock.getIntParameter(0);
        double tolerance = paramBlock.getDoubleParameter(1);
        boolean diagonal = (Boolean)paramBlock.getObjectParameter(2);
        return new RegionalizeOpImage(src, renderHints, layout, band, tolerance, diagonal);
    }
}

