/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.jiffleop;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import org.jaitools.CollectionFactory;
import org.jaitools.jiffle.Jiffle;
import org.jaitools.jiffle.JiffleException;
import org.jaitools.jiffle.runtime.JiffleIndirectRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiffleOpImage
extends OpImage {
    private final JiffleIndirectRuntime runtime;
    private final int band = 0;
    private final Rectangle bounds;

    public JiffleOpImage(Map<String, RenderedImage> sourceImages, ImageLayout layout, Map configuration, String script, String destVarName, Rectangle destBounds) {
        super(new Vector<RenderedImage>(sourceImages.values()), layout, configuration, false);
        try {
            Jiffle jiffle = new Jiffle();
            jiffle.setScript(script);
            Map imageParams = CollectionFactory.map();
            for (String varName : sourceImages.keySet()) {
                imageParams.put(varName, Jiffle.ImageRole.SOURCE);
            }
            imageParams.put(destVarName, Jiffle.ImageRole.DEST);
            jiffle.setImageParams(imageParams);
            jiffle.compile();
            this.runtime = (JiffleIndirectRuntime)jiffle.getRuntimeInstance(Jiffle.RuntimeModel.INDIRECT);
            for (String varName : sourceImages.keySet()) {
                this.runtime.setSourceImage(varName);
            }
            if (destBounds == null) {
                this.bounds = this.getSourceBounds();
                if (this.bounds == null) {
                    throw new IllegalArgumentException("No source images and no destination bounds specified");
                }
            } else {
                this.bounds = new Rectangle(destBounds);
            }
            this.runtime.setWorldByResolution((Rectangle2D)this.bounds, 1.0, 1.0);
        }
        catch (JiffleException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Rectangle mapSourceRect(Rectangle sourceRect, int sourceIndex) {
        return null;
    }

    public Rectangle mapDestRect(Rectangle destRect, int sourceIndex) {
        return this.getSourceImage(sourceIndex).getBounds();
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        int y = destRect.y;
        for (int iy = 0; iy < destRect.height; ++iy) {
            int x = destRect.x;
            for (int ix = 0; ix < destRect.width; ++ix) {
                dest.setSample(x, y, 0, this.runtime.evaluate((double)x, (double)y));
                ++x;
            }
            ++y;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        super.computeRect(sources, dest, destRect);
    }

    public Raster computeTile(int tileX, int tileY) {
        return super.computeTile(tileX, tileY);
    }

    private Rectangle getSourceBounds() {
        Rectangle r = null;
        if (this.getNumSources() > 0) {
            r = new Rectangle(this.getSourceImage(0).getBounds());
            for (int i = 1; i < this.getNumSources(); ++i) {
                r = r.union(this.getSourceImage(i).getBounds());
            }
        }
        return r;
    }
}

