package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AbsMethodNode extends AbstractNode {
  public AbsMethodNode(Location location, String name) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAbsMethodNode(this);
  }

  private final String name;
  public String getName() { return name; }

  private final List<AbstractArgsNode> argsBlocks = new ArrayList<AbstractArgsNode>();
  public AbsMethodNode addArgsBlock(AbstractArgsNode argsBlock) {
    if (argsBlock == null) { throw new NullPointerException(); }
    argsBlocks.add(argsBlock);
    return this;
  }
  public List<AbstractArgsNode> getArgsBlocks() { return argsBlocks; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((AbsMethodNode) obj).name)
      && argsBlocks.equals(((AbsMethodNode) obj).argsBlocks)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
      ^ argsBlocks.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
    addPropertyList(buffer, "argsBlock", argsBlocks);
  }

}
