package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AbstractArgsNode extends AbstractNode {
  public AbstractArgsNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAbstractArgsNode(this);
  }

  private final List<ArgNode> args = new ArrayList<ArgNode>();
  public AbstractArgsNode addArg(ArgNode arg) {
    if (arg == null) { throw new NullPointerException(); }
    args.add(arg);
    return this;
  }
  public List<ArgNode> getArgs() { return args; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && args.equals(((AbstractArgsNode) obj).args)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ args.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "arg", args);
  }

}
