package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AbstractBodyNode extends AbstractNode {
  public AbstractBodyNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAbstractBodyNode(this);
  }

  private final List<AbstractNode> subNodes = new ArrayList<AbstractNode>();
  public AbstractBodyNode addSubNode(AbstractNode subNode) {
    if (subNode == null) { throw new NullPointerException(); }
    subNodes.add(subNode);
    return this;
  }
  public List<AbstractNode> getSubNodes() { return subNodes; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && subNodes.equals(((AbstractBodyNode) obj).subNodes)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ subNodes.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "subNode", subNodes);
  }

}
