package org.jamon.node;

import java.util.ArrayList;
import java.util.List;

import org.jamon.api.Location;
public class AbstractPathNode extends AbstractNode {
  public AbstractPathNode(Location location) {
    super(location);
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAbstractPathNode(this);
  }

  private final List<AbstractPathElementNode> pathElements = new ArrayList<AbstractPathElementNode>();
  public AbstractPathNode addPathElement(AbstractPathElementNode pathElement) {
    if (pathElement == null) { throw new NullPointerException(); }
    pathElements.add(pathElement);
    return this;
  }
  public List<AbstractPathElementNode> getPathElements() { return pathElements; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && pathElements.equals(((AbstractPathNode) obj).pathElements)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ pathElements.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addPropertyList(buffer, "pathElement", pathElements);
  }

}
