package org.jamon.node;

import org.jamon.api.Location;
public class AliasDefNode extends AbstractNode {
  public AliasDefNode(Location location, String name, AbstractPathNode path) {
    super(location);
    if ((this.name = name) == null)
      { throw new NullPointerException(); }
    if ((this.path = path) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseAliasDefNode(this);
  }

  private final String name;
  public String getName() { return name; }

  private final AbstractPathNode path;
  public AbstractPathNode getPath() { return path; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && name.equals(((AliasDefNode) obj).name)
      && path.equals(((AliasDefNode) obj).path)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ name.hashCode()
      ^ path.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "name", name);
    addProperty(buffer, "path", path);
  }

}
