package org.jamon.node;

import org.jamon.api.Location;
public class ClassNode extends AbstractNode {
  public ClassNode(Location location, String content) {
    super(location);
    if ((this.content = content) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseClassNode(this);
  }

  private final String content;
  public String getContent() { return content; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && content.equals(((ClassNode) obj).content)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ content.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "content", content);
  }

}
