package org.jamon.node;

import org.jamon.api.Location;
public class EscapeDirectiveNode extends AbstractNode {
  public EscapeDirectiveNode(Location location, String escapeCode) {
    super(location);
    if ((this.escapeCode = escapeCode) == null)
      { throw new NullPointerException(); }
  }

  @Override public void apply(Analysis analysis)
  {
    analysis.caseEscapeDirectiveNode(this);
  }

  private final String escapeCode;
  public String getEscapeCode() { return escapeCode; }

  @Override public boolean equals(Object obj) {
    return obj != null
        && super.equals(obj)
      && escapeCode.equals(((EscapeDirectiveNode) obj).escapeCode)
    ;
  }

  @Override public int hashCode() {
    return super.hashCode()
      ^ escapeCode.hashCode()
    ;
  }

  @Override protected void propertiesToString(StringBuilder buffer) {
    super.propertiesToString(buffer);
    addProperty(buffer, "escapeCode", escapeCode);
  }

}
